

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetMonthStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetMonthStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetMonthStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetMonthStart]
  delete from GXDBVersions where name = 'DAGetMonthStart' and type = 5
END
GO

	CREATE FUNCTION DAGetMonthStart(@jobStartTime INTEGER, @calendarId INTEGER, @monthStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 						DATETIME
			DECLARE @monthStartDate 					DATETIME
			DECLARE @monthStartsFromDate			DATETIME
			DECLARE @prevMonthDate						DATETIME
			DECLARE @prevMonthStartDate				DATETIME
			DECLARE @prevMonthStartFromDate		DATETIME
			DECLARE @year 										INTEGER
			DECLARE @month 										INTEGER
			DECLARE @day 											INTEGER
			DECLARE @calType 									INTEGER

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @calType = 0
			SET @monthStartDate = 0

			SET @calType = (SELECT calType FROM APP_CustomCalendar WHERE id = @calendarId)
			IF (@calType > 2)
			BEGIN
			  SELECT @monthStartDate = startDate
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @jobStartDate
				AND endDate >= @jobStartDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar dates
			IF (@monthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				SET @monthStartDate = dbo.getStartDay(@year, @month, 0)
				SET @calType = 1	-- Standard calendar
			END

			IF (@monthStartsFrom = 1)
			BEGIN
				RETURN dbo.getUnixTime(@monthStartDate)
			END

			SET @monthStartsFromDate = DATEADD(DAY, @monthStartsFrom - 1, @monthStartDate)

			-- If jobStartTime = 2/20 and monthStart = 15, return should be 2/15
			-- If jobStartTime = 2/28 and monthStart = 28, return should be 2/28
			IF (@jobStartDate >= @monthStartsFromDate)
			BEGIN
				RETURN dbo.getUnixTime(@monthStartsFromDate)
			END

			--Job belongs to previous month, get previous month offset
			SET @prevMonthDate = DATEADD(DAY, -1, @monthStartDate)

			--Get the previous month start date
			SET @prevMonthStartDate = 0

			IF (@calType > 2)
			BEGIN
			  SELECT @prevMonthStartDate = startDate
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @prevMonthDate
				AND endDate >= @prevMonthDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar dates
			IF (@prevMonthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				SET @monthStartDate = dbo.getStartDay(@year, @month, 0)

				IF (@monthStartsFrom = 1)
				BEGIN
					RETURN dbo.getUnixTime(@monthStartDate)
				END

				SET @monthStartsFromDate = DATEADD(DAY, @monthStartsFrom - 1, @monthStartDate)

				-- If jobStartTime = 2/20 and monthStart = 15, return should be 2/15
				-- If jobStartTime = 2/28 and monthStart = 28, return should be 2/28
				IF (@jobStartDate >= @monthStartsFromDate)
				BEGIN
					RETURN dbo.getUnixTime(@monthStartsFromDate)
				END

				--Job belongs to previous month, get previous month offset
				SET @prevMonthDate = DATEADD(DAY, -1, @monthStartDate)

				SET @year = DATEPART(YEAR, @prevMonthDate)
				SET @month = DATEPART(MONTH, @prevMonthDate)
				SET @day = DATEPART(DAY, @prevMonthDate)
				SET @prevMonthStartDate = dbo.getStartDay(@year, @month, 0)
			END

			--Get the Previous Month Start Date
			SET @prevMonthStartFromDate = DATEADD(DAY, @monthStartsFrom - 1, @prevMonthStartDate)

			-- If jobStartTime = 2/20 and monthStart = 25, return should be 1/25
			-- If jobStartTime = 2/28 and monthStart = 31, return should be 2/1
			-- If jobStartTime = 3/30 and monthStart = 31, return should be 3/1
			IF (@prevMonthStartFromDate < @monthStartDate)
				SET @monthStartsFromDate = @prevMonthStartFromDate
			ELSE
				SET @monthStartsFromDate = @monthStartDate

			RETURN dbo.getUnixTime(@monthStartsFromDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetMonthStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetMonthStart' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetMonthStart',  '1.2', 'DAGetMonthStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
