

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetMonthEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetMonthEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetMonthEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetMonthEnd]
  delete from GXDBVersions where name = 'DAGetMonthEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetMonthEnd(@jobStartTime INTEGER, @calendarId INTEGER, @monthStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @monthStartDate 	INTEGER
			DECLARE	@monthEndDate 		DATETIME

			SET @monthEndDate = 0

			-- Get the StartDate of Month
			SET	@monthStartDate = dbo.DAGetMonthStart(@jobStartTime, @calendarId, @monthStartsFrom)
			SET @monthEndDate = dbo.getDateTime(@monthStartDate)

			WHILE (@monthStartDate = dbo.DAGetMonthStart(dbo.getUnixTime(@monthEndDate), @calendarId, @monthStartsFrom))
			BEGIN
				SET @monthEndDate = DATEADD(DAY, 1, @monthEndDate)
			END

			SET @monthEndDate = DATEADD(DAY, -1, @monthEndDate)

			RETURN dbo.getUnixTime(@monthEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetMonthEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetMonthEnd' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetMonthEnd',  '1.1', 'DAGetMonthEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
