

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetHourlyStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetHourlyStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetHourlyStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetHourlyStart]
  delete from GXDBVersions where name = 'DAGetHourlyStart' and type = 5
END
GO

	CREATE FUNCTION DAGetHourlyStart(@jobStartTime INTEGER, @EveryXHours INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @dayStartTime 						DATETIME
			DECLARE	@hourlyStartTime					DATETIME

			IF @EveryXHours < 1
				SET @EveryXHours = 1

			IF @EveryXHours > 24
				SET @EveryXHours = 24

			IF @EveryXHours > 0
			BEGIN
				SET @dayStartTime = dbo.getDateTime(dbo.DAGetDailyStart(@jobStartTime, @minutesSinceDayStarts))

				SET @hourlyStartTime = DATEADD(HH, ((DATEDIFF(HH, @dayStartTime, dbo.getDateTime(@jobStartTime))/@EveryXHours) * @EveryXHours), @dayStartTime)

				IF @hourlyStartTime > dbo.getDateTime(@jobStartTime)
					SET @hourlyStartTime = DATEADD(HH, -1 * @EveryXHours, @hourlyStartTime)
			END

			RETURN dbo.getUnixTime(@hourlyStartTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetHourlyStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetHourlyStart' AND revision = '1.3')

  insert into GXDBVersions values(5, 'DAGetHourlyStart',  '1.3', 'DAGetHourlyStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
