

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetHourlyEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetHourlyEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetHourlyEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetHourlyEnd]
  delete from GXDBVersions where name = 'DAGetHourlyEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetHourlyEnd(@jobStartTime INTEGER, @EveryXHours INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE	@hourlyStartTime		DATETIME
			DECLARE	@hourlyEndTime			DATETIME
			DECLARE @dayEndTime		 			DATETIME

			SET @dayEndTime = dbo.getDateTime(dbo.DAGetDailyEnd(@jobStartTime, @minutesSinceDayStarts))
			SET @hourlyStartTime = dbo.getDateTime(dbo.DAGetHourlyStart(@jobStartTime, @EveryXHours, @minutesSinceDayStarts))
			SET @hourlyEndTime = dbo.getDateTime(dbo.getUnixTime(DATEADD(HH, @EveryXHours, @hourlyStartTime)) - 1)

			IF @hourlyEndTime > @dayEndTime
				SET @hourlyEndTime = @dayEndTime

			RETURN dbo.getUnixTime(@hourlyEndTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetHourlyEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetHourlyEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetHourlyEnd',  '1.2', 'DAGetHourlyEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
