

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetHalfYearEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetHalfYearEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetHalfYearEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetHalfYearEnd]
  delete from GXDBVersions where name = 'DAGetHalfYearEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetHalfYearEnd(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @halfYearStartDate 	INTEGER
			DECLARE @halfYearEndDate 		DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @endMonth 					INTEGER

			SET @year 	= 0
			SET @month 	= 0
			SET @halfYearEndDate = 0

			-- Get the StartDate of Half Year
			SET @halfYearStartDate = dbo.DAGetHalfYearStart(@jobStartTime, @calendarId)

			SELECT @year = year, @month = month
			FROM APP_CustomCalendarMonths
			WHERE startDate = dbo.getDateTime(@halfYearStartDate)
			AND		calendarId = @calendarId

			--Custom Calendar
			IF (@month <> 0 AND @year <> 0)
			BEGIN
				SET @endMonth =  CASE (((@month % 12) + 5) % 12) WHEN 0 THEN 12 ELSE (((@month % 12) + 5) % 12) END
				IF (@endMonth <= @month)
				BEGIN
					SET @year = @year + 1
				END

				SELECT @halfYearEndDate = endDate
				FROM APP_CustomCalendarMonths
				WHERE year = @year
				AND		month = @endMonth
				AND		calendarId = @calendarId
			END

			--Standard Calendar
			IF (@halfYearEndDate = 0)
			BEGIN
				SET @halfYearEndDate = DATEADD(MONTH, 6, dbo.getDateTime(@halfYearStartDate))
				SET @halfYearEndDate = DATEADD(DAY, -1, @halfYearEndDate)
			END

			RETURN dbo.getUnixTime(@halfYearEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetHalfYearEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetHalfYearEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetHalfYearEnd',  '1.2', 'DAGetHalfYearEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
