

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetDailyStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetDailyStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetDailyStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetDailyStart]
  delete from GXDBVersions where name = 'DAGetDailyStart' and type = 5
END
GO

	CREATE FUNCTION DAGetDailyStart(@jobStartTime INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @dayStartTime 			DATETIME
			DECLARE	@dailyStartTime			DATETIME

			IF @minutesSinceDayStarts < 0
				SET @minutesSinceDayStarts = 0

			IF @minutesSinceDayStarts >= (24 * 60)
				SET @minutesSinceDayStarts = 0

			SET @dayStartTime = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)

			SET @dailyStartTime = DATEADD(MI, @minutesSinceDayStarts, @dayStartTime)

			IF @dailyStartTime > dbo.getDateTime(@jobStartTime)
				SET @dailyStartTime = DATEADD(DAY, -1, @dailyStartTime)

			RETURN dbo.getUnixTime(@dailyStartTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetDailyStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetDailyStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetDailyStart',  '1.1', 'DAGetDailyStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
