

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetDailyEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetDailyEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetDailyEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetDailyEnd]
  delete from GXDBVersions where name = 'DAGetDailyEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetDailyEnd(@jobStartTime INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE	@dailyStartTime			DATETIME
			DECLARE	@dailyEndTime				DATETIME

			SET @dailyStartTime = dbo.getDateTime(dbo.DAGetDailyStart(@jobStartTime, @minutesSinceDayStarts))
			SET @dailyEndTime = dbo.getDateTime(dbo.getUnixTime(DATEADD(DAY, 1, @dailyStartTime)) - 1)

			RETURN dbo.getUnixTime(@dailyEndTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetDailyEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetDailyEnd' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetDailyEnd',  '1.1', 'DAGetDailyEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
