

--  ------------  Generated from [../../../Source/CommServer/Db/Function/CreateHTMLTableFromXML.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: CreateHTMLTableFromXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CreateHTMLTableFromXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CreateHTMLTableFromXML]
  delete from GXDBVersions where name = 'CreateHTMLTableFromXML' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION CreateHTMLTableFromXML
(
    @SelectForXmlPathRowElementsXsinil XML,
    @tblClass VARCHAR(100), --NULL to omit this class
    @thClass VARCHAR(100),  --same
    @tbClass VARCHAR(100)  --same
)
RETURNS NVARCHAR(MAX)
AS
BEGIN
DECLARE @htmltable NVARCHAR(MAX)=CAST((SELECT @tblClass AS [@class]  ,
	 800 AS [@width] ,
	 0 AS [@cellpadding],
	 0 AS [@cellspacing],
     @thClass AS [thead/@class],
     @SelectForXmlPathRowElementsXsinil.query(
              N'let $first:=/tablerows[1]
                return
                <tr>
                {
                for $column in $first/*
                return <th align="center" valign="top" scope="col" class="tableHeader">{if(not(empty($column/@caption))) then xs:string($column/@caption) else local-name($column)}</th>
                }
                </tr>') AS thead
    ,@tbClass AS [tbody/@class]
    ,@SelectForXmlPathRowElementsXsinil.query(
               N'for $row in /tablerows
                 return
                 <tr>{$row/@class}
                 {
                 for $data in $row/*
                 return
				 if(empty($data/@class)) then
					 if(empty($data/@link)) then
						<td valign="top" class="tableData">{string($data)}</td>
					 else
						<td valign="top" class="tableData"><a href="{$data/@link}">{string($data)}</a></td>
				 else
				 	 if(empty($data/@link)) then
						<td valign="top">{$data/@class}{string($data)}</td>
					 else
						<td valign="top">{$data/@class}<a href="{$data/@link}">{string($data)}</a></td>
                 }
                 </tr>') AS tbody
    FOR XML PATH('table'),TYPE) AS NVARCHAR(MAX))
RETURN @htmltable
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CreateHTMLTableFromXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CreateHTMLTableFromXML' AND revision = '')

  insert into GXDBVersions values(5, 'CreateHTMLTableFromXML',  '', 'CreateHTMLTableFromXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
