

--  ------------  Generated from [../../../Source/CommServer/Db/Function/CompletedBackupJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CompletedBackupJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CompletedBackupJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CompletedBackupJobs]
  delete from GXDBVersions where name = 'CompletedBackupJobs' and type = 5
END
GO

 CREATE FUNCTION CompletedBackupJobs (
	@TimeRangeBegin	DATETIME,
	@TimeRangeEnd	DATETIME,
	@CountAgedJobs	INTEGER,
	@IsSummary		INTEGER
 )
 RETURNS @Results TABLE (
	JobId			INTEGER,
	CommCell		NVARCHAR(256),
	ClientGroup		NVARCHAR(MAX),
	Client			NVARCHAR(256),
	Agent			NVARCHAR(256),
	Instance		NVARCHAR(256),
	Backupset		NVARCHAR(256),
	Subclient		NVARCHAR(256),
	BackupType		NVARCHAR(16),
	ScanType		NVARCHAR(16),
	StoragePolicy	NVARCHAR(256),
	StartTime		VARCHAR(20),
	EndTime			VARCHAR(20),
	StartedFrom		NVARCHAR(32),
	StartedBy		NVARCHAR(256),
	Status			NVARCHAR(32),
	AppSizeGB		DECIMAL(20,2),
	AppSizeChangePtc INT,
	CompressionPtc	DECIMAL(10,2),
	DataWrittenGB	DECIMAL(20,2),
	SpaceSavingPct	DECIMAL(10,2),
	TransferredGB	DECIMAL(20,2),
	TransferTime	NVARCHAR(32),
	ThroughputGBPerHr DECIMAL(10,2),
	ProtectedObjects BIGINT,
	FailedObjects	BIGINT,
	FailedFolders	BIGINT,
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 DECLARE @csName	 VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @TotalSize	BIGINT
 DECLARE @StartTime	INT = dbo.GetUnixTime(dbo.LocalToUTCTime(@TimeRangeBegin, @csTimeZone))
 DECLARE @EndTime	INT = dbo.GetUnixTime(dbo.LocalToUTCTime(@TimeRangeEnd, @csTimeZone))

 IF	@IsSummary > 0
 INSERT	INTO @Results
 SELECT	COUNT(B.jobId), @csName, ISNULL(CG.ClientGroups, ''), CL.name, IDA.name,
 		dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName,
 		'', '', '', '', '', '', '', '',
 		ROUND(SUM(B.totalUncompBytes)/1024.0/1024.0/1024.0, 2), 0, 0,
 		ROUND(SUM(D.SizeOnMedia)/1024.0/1024.0/1024.0, 2), 0,
 		ROUND(SUM(B.nwTransBytes)/1024.0/1024.0/1024.0, 2), '', 0, 0, 0, 0, ''
 FROM	(SELECT	JDS.jobId, JDS.commCellId, SUM(JDS.SizeOnMedia) AS SizeOnMedia
		FROM	JMBkpStats BKP WITH (NOLOCK)
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON JDS.jobId = BKP.jobId AND JDS.commCellId = BKP.commCellId
				INNER JOIN archGroup AG WITH (NOLOCK) ON ((AG.defaultCopy = JDS.archGrpCopyId AND BKP.opType IN (4, 14,18,76))
	         											  OR (JDS.archGrpCopyId  = AG.defaultSnapCopy AND BKP.opType IN (59,65)))
		WHERE	BKP.servEndDate BETWEEN @StartTime AND @EndTime
 			AND BKP.appType < 1000 AND BKP.appType NOT BETWEEN 600 AND 700
			AND (@CountAgedJobs = 1 OR BKP.dataStatus = 0)
		GROUP BY JDS.jobId, JDS.commCellId) D
 		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = D.jobId AND B.commCellId = D.commCellId
 		INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = B.appId
		INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = A.clientId
		INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = A.appTypeId
		INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id = A.instance
		INNER JOIN APP_BackupsetName BS WITH (NOLOCK) ON BS.id = A.backupset
		LEFT OUTER JOIN ClientGroupsStringView CG ON CG.ClientId = A.clientId
 WHERE	(B.status IN (1, 14) OR B.status = 3 AND IDA.isCWEJobValid = 1)
 GROUP BY ISNULL(CG.ClientGroups, ''), CL.name, IDA.name, dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName
 ORDER BY ISNULL(CG.ClientGroups, ''), CL.name, IDA.name, dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName
 ELSE
 INSERT	INTO @Results
 SELECT	B.jobId, @csName, ISNULL(CG.ClientGroups, ''), CL.name, IDA.name,
 		dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName,
 		dbo.GetJobBackupTypeDisplay(B.bkpLevel), dbo.GetJobScanTypeString(B.scanType), D.spName,
 		dbo.UTCToLocalStringTime(dbo.GetDateTime(B.servStartDate), @csTimeZone),
 		dbo.UTCToLocalStringTime(dbo.GetDateTime(B.servEndDate), @csTimeZone),
 		dbo.GetJobInitFromString(B.initFrom), B.userName, dbo.GetJobStatusName(B.status),
 		ROUND(B.totalUncompBytes/1024.0/1024.0/1024.0, 2), B.percentageChange,
 		CASE WHEN B.totalCompBytes > 0 AND B.totalUncompBytes > B.totalCompBytes THEN ROUND(100.0*(B.totalUncompBytes - B.totalCompBytes)/B.totalUncompBytes, 2) ELSE 0 END,
 		ROUND(D.SizeOnMedia/1024.0/1024.0/1024.0, 2),
 		CASE WHEN B.totalUncompBytes > D.SizeOnMedia THEN ROUND(100.0*(B.totalUncompBytes - D.SizeOnMedia)/B.totalUncompBytes, 2) ELSE 0 END,
 		ROUND(B.nwTransBytes/1024.0/1024.0/1024.0, 2),
 		RTRIM(B.totalWriteTime/3600) + ':' + RIGHT('0'+RTRIM((B.totalWriteTime%3600)/60), 2) + ':' + RIGHT('0'+RTRIM((B.totalWriteTime%3600)%60), 2),
 		CASE WHEN B.totalWriteTime > 0 THEN ROUND(3600.0*B.totalUncompBytes/B.totalWriteTime/1024.0/1024.0/1024.0, 2) ELSE 0 END,
 		B.totalNumOfFiles, B.scanFileFailures + B.backupFileFailures, B.scanFolderFailures + B.backupFolderFailures, @csTimeZone
 FROM	(SELECT	JDS.jobId, JDS.commCellId, JDS.appId, AG.name AS spName, SUM(JDS.SizeOnMedia) AS SizeOnMedia
		FROM	JMBkpStats BKP WITH (NOLOCK)
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON JDS.jobId = BKP.jobId AND JDS.commCellId = BKP.commCellId
				INNER JOIN archGroup AG WITH (NOLOCK) ON ((AG.defaultCopy = JDS.archGrpCopyId AND BKP.opType IN (4, 14,18,76))
	         											  OR (JDS.archGrpCopyId  = AG.defaultSnapCopy AND BKP.opType IN (59,65)))
		WHERE	BKP.servEndDate BETWEEN @StartTime AND @EndTime
 			AND BKP.appType < 1000 AND BKP.appType NOT BETWEEN 600 AND 700
			AND (@CountAgedJobs = 1 OR BKP.dataStatus = 0)
		GROUP BY JDS.jobId, JDS.commCellId, JDS.appId, AG.name) D
 		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = D.jobId AND B.commCellId = D.commCellId
 		INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = B.appId
		INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = A.clientId
		INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = A.appTypeId
		INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id = A.instance
		INNER JOIN APP_BackupsetName BS WITH (NOLOCK) ON BS.id = A.backupset
		LEFT OUTER JOIN ClientGroupsStringView CG ON CG.ClientId = A.clientId
 WHERE	(B.status IN (1, 14) OR B.status = 3 AND IDA.isCWEJobValid = 1)
 ORDER BY B.jobId DESC

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CompletedBackupJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CompletedBackupJobs' AND revision = '1.4.76.1')

  insert into GXDBVersions values(5, 'CompletedBackupJobs',  '1.4.76.1', 'CompletedBackupJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
