

--  ------------  Generated from [../../../Source/CommServer/Db/Function/CommCellBackupInfoFn.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CommCellBackupInfoFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBackupInfoFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CommCellBackupInfoFn]
  delete from GXDBVersions where name = 'CommCellBackupInfoFn' and type = 5
END
GO

	CREATE FUNCTION CommCellBackupInfoFn(@days int)
	RETURNS
	@listJobs table (jobid  bigint,
    appid  int,
	jobinitfrom nvarchar(20),
	clientname  nvarchar(1024),
	idataagent  nvarchar(1024),
	instance    nvarchar(1024),
	backupset   nvarchar(1024),
	subclient   nvarchar(1024),
	data_sp     nvarchar(1024),
	backuplevelInt  int,
	backuplevel nvarchar(64),
	incrlevel  int,
	jobstatusInt int,
	jobstatus nvarchar(20),
	jobfailedreason  nvarchar(max),
	startdateunixsec  int,
	enddateunixsec int,
	startdate  datetime,
	enddate    datetime,
	durationunixsec  int,
	duration  nvarchar(20),
	numstreams  int,
	numbytesuncomp  bigint,
	numbytescomp bigint,
	numobjects  bigint,
	isAged  int,
	isAgedStr nvarchar(20),
	xmlJobOptions xml,
	retentionDays int,
	systemStateBackup int
	)
	-- WITH ENCRYPTION
	AS
	BEGIN
	---Copyright (c) 1998  CommVault Systems, Inc.
	---Display Backup History Info
	DECLARE @date int =0
	IF ( @days > 0 )
		SET @date =dbo.GetUnixTime(DATEADD(day, -@days,GETUTCDATE()))
	IF ( @days > 0 )
	BEGIN
		INSERT INTO @listJobs
		SELECT
		jobid=BS.jobId,
		appid=BS.appid,
		jobinitfrom=
		case BS.initFrom
		when 1 then 'Command Line'
		when 2 then 'Gui'
		when 3 then 'Schedule'
		when 4 then 'System'
					end,
		clientname = dbo.APP_Client.name,
		idataagent = dbo.APP_IDAType.name,
		instance = APP_InstanceName.name,
		backupset = dbo.APP_BackupSetName.Name,
		subclient = dbo.app_application.SubClientName,
		data_sp=dbo.archGroup.name ,
		backuplevelInt =BS.bkplevel,
		backuplevel =
		CASE  BS.bkplevel
		 WHEN 1 THEN 'Full'
		 WHEN 2 THEN 'Incremental'
		 WHEN 4 THEN 'Differential'
		 WHEN 64 THEN 'SyntheticFull'
		 WHEN 128 THEN 'SyntheticFull'
		 WHEN 256 THEN 'Transaction Log w. NoTruncate'
		 WHEN 512 THEN 'ASR'
		 WHEN 1024 THEN 'Offline Full'
		 WHEN 16384 THEN 'Incremental'
		 WHEN 32768 THEN 'Online Full'
		 ELSE 'Unknown'
		 END,
		incrlevel =
		case  BS.bkplevel
		when 2 then
			 case BS.oraSublevel
			 when 0 then 1
			 else BS.oraSublevel
			 end
		else 0
		end,
		jobstatusInt =BS.status,
		jobstatus =
		 CASE BS.status
		 WHEN 1 THEN 'Success'
		 WHEN 2 THEN 'Failed'
		 WHEN 3 THEN 'PartialSuccess'
		 WHEN 4 THEN 'Killed'
		 WHEN 5 THEN 'Stopped'
		 WHEN 6 THEN 'Interrupted'
		 WHEN 9 THEN 'Failed to Start'
		 ELSE 'Unknown'
		 END,
		jobfailedreason =
		case
		when BS.status > 1 then
			case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 				then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
						from JMBkpAtmptStats WITH (NOLOCK)
						where jobid =Bs.jobid)
				 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
			end
		else ''
		end,
		startdateunixsec =  BS.servStartdate,
		enddateunixsec = BS.servEndDate,
		startdate = dbo.GetDateTime(BS.servStartDate),
		enddate =dbo.GetDateTime(BS.servEndDate),
		durationunixsec = BS.duration,
		duration = case
		  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
		  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
		  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
		  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
		  else ''
		  end,
		numstreams = BS.numStreams,
		numbytesuncomp= BS.totaluncompbytes,
		numbytescomp=BS.totalcompbytes,
		numobjects=BS.totalNumOfFiles + BS.totalNumOfFolders,
		isAged=
		 (CASE BS.agedtime
			 WHEN 0 THEN 0
			 WHEN NULL THEN 0
			 ELSE 1
		 END),
		isAgedStr=
		 (CASE BS.agedtime
			 WHEN 0 THEN 'No'
			 WHEN NULL THEN 'No'
			 ELSE 'Yes'
		 END),
		xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
		AR.retentionDays,
		systemStateBackup = CASE
								WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1
								ELSE	0
							END
		FROM  dbo.APP_Application WITH (NOLOCK) INNER JOIN
			  dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
			  dbo.APP_InstanceName WITH (NOLOCK) ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
			  dbo.APP_iDAType WITH (NOLOCK) ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
			  dbo.APP_Client WITH (NOLOCK) ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
			  dbo.JMBkpStats AS BS WITH (NOLOCK) ON dbo.APP_Application.id = BS.appId
			  LEFT OUTER JOIN  dbo.archGroup WITH (NOLOCK) ON BS.dataArchGrpId = dbo.archGroup.id
			  LEFT OUTER JOIN  dbo.archAgingRule AR WITH (NOLOCK) ON AR.copyId = dbo.archGroup.defaultCopy AND BS.opType NOT IN (59, 65)
				OR AR.copyId = dbo.archGroup.defaultSnapCopy AND BS.opType IN (59, 65)
		WHERE BS.servEndDate is NULL or BS.servEndDate >= @date
	END
	ELSE
	BEGIN
		INSERT INTO @listJobs
		SELECT
		jobid=BS.jobId,
		appid=BS.appid,
		jobinitfrom=
		case BS.initFrom
		when 1 then 'Command Line'
		when 2 then 'Gui'
		when 3 then 'Schedule'
		when 4 then 'System'
		end,
		clientname = dbo.APP_Client.name,
		idataagent = dbo.APP_IDAType.name,
		instance = APP_InstanceName.name,
		backupset = dbo.APP_BackupSetName.Name,
		subclient = dbo.app_application.SubClientName,
		data_sp=dbo.archGroup.name ,
		backuplevelInt =BS.bkplevel,
		backuplevel =
		CASE  BS.bkplevel
		 WHEN 1 THEN 'Full'
		 WHEN 2 THEN 'Incremental'
		 WHEN 4 THEN 'Differential'
		 WHEN 64 THEN 'SyntheticFull'
		 WHEN 128 THEN 'SyntheticFull'
		 WHEN 256 THEN 'Transaction Log w. NoTruncate'
		 WHEN 512 THEN 'ASR'
		 WHEN 1024 THEN 'Offline Full'
		 WHEN 16384 THEN 'Incremental'
		 WHEN 32768 THEN 'Online Full'
		 ELSE 'Unknown'
		 END,
		incrlevel =
		case  BS.bkplevel
		when 2 then
			 case BS.oraSublevel
			 when 0 then 1
			 else BS.oraSublevel
			 end
		else 0
		end,
		jobstatusInt =BS.status,
		jobstatus =
		 CASE BS.status
		 WHEN 1 THEN 'Success'
		 WHEN 2 THEN 'Failed'
		 WHEN 3 THEN 'PartialSuccess'
		 WHEN 4 THEN 'Killed'
		 WHEN 5 THEN 'Stopped'
		 WHEN 6 THEN 'Interrupted'
		 WHEN 9 THEN 'Failed to Start'
		 ELSE 'Unknown'
		 END,
		jobfailedreason =
		case
		when BS.status > 1 then
			case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 				then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
						from JMBkpAtmptStats WITH (NOLOCK)
						where jobid =Bs.jobid)
				 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
			end
		else ''
		end,
		startdateunixsec =  BS.servStartdate,
		enddateunixsec = BS.servEndDate,
		startdate = dbo.GetDateTime(BS.servStartDate),
		enddate =dbo.GetDateTime(BS.servEndDate),
		durationunixsec = BS.duration,
		duration = case
		  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
		  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
		  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
		  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
		  else ''
		  end,
		numstreams = BS.numStreams,
		numbytesuncomp= BS.totaluncompbytes,
		numbytescomp=BS.totalcompbytes,
		numobjects=BS.totalNumOfFiles + BS.totalNumOfFolders,
		isAged=
		 (CASE BS.agedtime
			 WHEN 0 THEN 0
			 WHEN NULL THEN 0
			 ELSE 1
		 END),
		isAgedStr=
		 (CASE BS.agedtime
			 WHEN 0 THEN 'No'
			 WHEN NULL THEN 'No'
			 ELSE 'Yes'
		 END),
		xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
		AR.retentionDays,
		systemStateBackup = CASE
								WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1
								ELSE	0
							END
		FROM  dbo.APP_Application WITH (NOLOCK) INNER JOIN
			  dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
			  dbo.APP_InstanceName WITH (NOLOCK) ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
			  dbo.APP_iDAType WITH (NOLOCK) ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
			  dbo.APP_Client WITH (NOLOCK) ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
			  dbo.JMBkpStats AS BS WITH (NOLOCK) ON dbo.APP_Application.id = BS.appId
			  LEFT OUTER JOIN  dbo.archGroup WITH (NOLOCK) ON BS.dataArchGrpId = dbo.archGroup.id
			  LEFT OUTER JOIN  dbo.archAgingRule AR WITH (NOLOCK) ON AR.copyId = dbo.archGroup.defaultCopy AND BS.opType NOT IN (59, 65)
				OR AR.copyId = dbo.archGroup.defaultSnapCopy AND BS.opType IN (59, 65)
	END
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CommCellBackupInfoFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CommCellBackupInfoFn' AND revision = '1.8.86.2')

  insert into GXDBVersions values(5, 'CommCellBackupInfoFn',  '1.8.86.2', 'CommCellBackupInfoFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
