

--  ------------  Generated from [../../../Source/CommServer/Db/Function/ClientLocalToUTCTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ClientLocalToUTCTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientLocalToUTCTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ClientLocalToUTCTime]
  delete from GXDBVersions where name = 'ClientLocalToUTCTime' and type = 5
END
GO

	CREATE FUNCTION ClientLocalToUTCTime(@LocalTime DATETIME, @ChildID integer)
	RETURNS DATETIME
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @UTCTime	DateTime
		DECLARE @DSTFlag	integer
		DECLARE @Bias		integer
		DECLARE @STDBias	integer
		DECLARE @DSTBias	integer
		DECLARE @STDDate	DATETIME
		DECLARE @DSTDate	DATETIME
		DECLARE @CurrentYear	integer
		--Get the timezone info from the APP_Client table
		DECLARE @attrv varchar(255)
		DECLARE @timeZoneName varchar(255)
		DECLARE @count int
		DECLARE @CHAR int
		DECLARE @position int
		DECLARE @length int
		BEGIN
			select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = @ChildID AND attrName = 'timezone' AND modified = 0
		END
		SET @CHAR = 1
		SET @count = 1
		SET @length = DATALENGTH(@attrv)
		SET @position = @length
		WHILE (@position > 0 AND  @CHAR <> 58)
			BEGIN
			SET @CHAR = ASCII(SUBSTRING(@attrv, @position, 1))
			SET @position = @position - 1
		END
		SET @timeZoneName =  RIGHT(@attrv,@length - @position-1)
		SET @UTCTime = dbo.LocalToUTCTime(@LocalTime , @timeZoneName)
		RETURN @UTCTime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ClientLocalToUTCTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ClientLocalToUTCTime' AND revision = '1.4.304.1')

  insert into GXDBVersions values(5, 'ClientLocalToUTCTime',  '1.4.304.1', 'ClientLocalToUTCTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
