

--  ------------  Generated from [../../../Source/CommServer/Db/Function/ClientGroupsString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ClientGroupsString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientGroupsString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ClientGroupsString]
  delete from GXDBVersions where name = 'ClientGroupsString' and type = 5
END
GO

 CREATE FUNCTION ClientGroupsString (
	@Client_ID		INTEGER
	)
 RETURNS @Results TABLE (
	ClientId		INT,
	ClientGroups	NVARCHAR(MAX)
 )
 AS
 BEGIN

 	DECLARE	@tblClientGroupList TABLE (Key1 BIGINT, Key2 BIGINT, ClientGroups NVARCHAR(MAX))
 	DECLARE	@tblClientGroupKey TABLE (ClientId INT, Key1 BIGINT, Key2 BIGINT)

 	INSERT INTO @tblClientGroupKey
 	SELECT	clientId, SUM(CAST(clientGroupId AS BIGINT)), SUM(CAST(clientGroupId AS BIGINT)*CAST(clientGroupId AS BIGINT))
 	FROM	APP_ClientGroupAssoc
 	WHERE	(@Client_ID = 0 OR clientId = @Client_ID)
 	GROUP BY clientId

 	DECLARE ClientGroupListCursor CURSOR FOR
 	SELECT	Key1, Key2, CG.name
 	FROM	APP_ClientGroup CG, APP_ClientGroupAssoc CGA,
 			(SELECT	Key1, Key2, MIN(ClientId) AS ClientId
 			FROM	@tblClientGroupKey
 			GROUP BY Key1, Key2) T
 	WHERE	CG.id = CGA.clientGroupId AND CGA.clientId = T.ClientId
 	ORDER BY Key1, Key2, CG.id

 	DECLARE	@k1		BIGINT = 0
 	DECLARE	@k2		BIGINT = 0
 	DECLARE	@key1	BIGINT = 0
 	DECLARE	@key2	BIGINT = 0
 	DECLARE	@name	NVARCHAR(512) = ''
 	DECLARE	@list	NVARCHAR(MAX) = ''

 	OPEN ClientGroupListCursor
 		FETCH NEXT FROM ClientGroupListCursor INTO @k1, @k2, @name
 	WHILE @@FETCH_STATUS = 0
 	BEGIN
 		IF	@k1 = @key1 AND @k2 = @key2
 			SET @list = (@list + '; ' + @name)
 		ELSE
 		BEGIN
 			IF	@key1 > 0 AND @key2 > 0
 				INSERT	INTO @tblClientGroupList
 				SELECT	@key1, @key2, @list

 			SET @list = @name
 			SET	@key1 = @k1
 			SET @key2 = @k2
 		END

 		FETCH NEXT FROM ClientGroupListCursor INTO @k1, @k2, @name
 	END
 	CLOSE ClientGroupListCursor
 	DEALLOCATE ClientGroupListCursor

 	IF	@key1 > 0 AND @key2 > 0
 		INSERT	INTO @tblClientGroupList
 		SELECT	@key1, @key2, @list

 	INSERT INTO @Results
 	SELECT	K.ClientId, L.ClientGroups
 	FROM	@tblClientGroupKey K, @tblClientGroupList L
 	WHERE	K.Key1 = L.Key1 AND K.Key2 = L.Key2

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ClientGroupsString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ClientGroupsString' AND revision = '1.5')

  insert into GXDBVersions values(5, 'ClientGroupsString',  '1.5', 'ClientGroupsString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
