

--  ------------  Generated from [../../../Source/CommServer/Db/Function/CellLocalToUTCTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CellLocalToUTCTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CellLocalToUTCTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CellLocalToUTCTime]
  delete from GXDBVersions where name = 'CellLocalToUTCTime' and type = 5
END
GO

	CREATE FUNCTION CellLocalToUTCTime(@LocalTime DATETIME, @commCellId INT)
	RETURNS DATETIME
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @commCellTimeZoneName nvarchar(255) = ( SELECT  timeZone
		                                                FROM    APP_CommCell
		                                                WHERE   id = @commCellId)
		SELECT  @commCellTimeZoneName = TimeZoneStdName
		FROM    SchedTimeZone
		WHERE   TimeZoneName = SUBSTRING(@commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, 0) + 1) + 1, 255)
		RETURN dbo.LocalToUTCDateTimeConversionManaged(@LocalTime, @commCellTimeZoneName)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CellLocalToUTCTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CellLocalToUTCTime' AND revision = '1.2.212.1')

  insert into GXDBVersions values(5, 'CellLocalToUTCTime',  '1.2.212.1', 'CellLocalToUTCTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
