

--  ------------  Generated from [../../../Source/CommServer/Db/Function/CCSComputeTableHashRows.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: CCSComputeTableHashRows'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CCSComputeTableHashRows]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CCSComputeTableHashRows]
  delete from GXDBVersions where name = 'CCSComputeTableHashRows' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION CCSComputeTableHashRows(@bytes INT, @tableString NVARCHAR(MAX))
RETURNS @hashRows TABLE (
	chunk		INT,
	value		VARBINARY(128),
	bytes		INT
)
AS
BEGIN
	-- Currently a max of 8 CCS Hash Bucket rows supported for a max string size of 64K
	INSERT INTO @hashRows (chunk, value, bytes)
SELECT 1, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 1, 8000)), @bytes
		UNION ALL
SELECT 8001, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 8001, 8000)), @bytes
		WHERE @bytes > 8000
		UNION ALL
SELECT 16001, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 16001, 8000)), @bytes
		WHERE @bytes > 16000
		UNION ALL
SELECT 24001, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 24001, 8000)), @bytes
		WHERE @bytes > 24000
		UNION ALL
SELECT 32001, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 32001, 8000)), @bytes
		WHERE @bytes > 32000
		UNION ALL
SELECT 40001, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 40001, 8000)), @bytes
		WHERE @bytes > 40000
		UNION ALL
SELECT 48001, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 48001, 8000)), @bytes
		WHERE @bytes > 48000
		UNION ALL
SELECT 56001, dbo.GetUTF16ToUTF8HashBytes('MD5',SUBSTRING(@tableString, 56001, 8000)), @bytes
		WHERE @bytes > 56000
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CCSComputeTableHashRows]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CCSComputeTableHashRows' AND revision = '1.1.2.1.48.1')

  insert into GXDBVersions values(5, 'CCSComputeTableHashRows',  '1.1.2.1.48.1', 'CCSComputeTableHashRows', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
