

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubTaskOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubTaskOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubTaskOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubTaskOption]
  delete from GXDBVersions where name = 'BuildSubTaskOption' and type = 5
END
GO

	CREATE FUNCTION BuildSubTaskOption(@taskId integer, @subTaskId integer, @optionType integer )
	RETURNS BIGINT
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @bitOption		BIGINT
		DECLARE @bitLOption		VARBINARY(MAX)
		DECLARE @bitHOption		VARBINARY(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		SET @count = 0
		SET @bitLOption = 0
		SET @bitHOption = 0
		SET @bitOption = 0
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) value FROM TM_SubTaskOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
									subTaskId = @subTaskId), @bitVal)
			IF @bitVal != 0
				IF @count < 31
					SET @bitLOption = @bitLOption + POWER(2, @count)
				ELSE
					SET @bitHOption = @bitHOption + POWER(2, @count-31)
			SET @count = @count + 1
		END
		SET @bitOption = dbo.GetBigIntFromInt(@bitHOption, @bitLOption)
		RETURN @bitOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubTaskOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubTaskOption' AND revision = '1.6.278.1')

  insert into GXDBVersions values(5, 'BuildSubTaskOption',  '1.6.278.1', 'BuildSubTaskOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
