

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubTaskExtOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubTaskExtOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubTaskExtOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubTaskExtOption]
  delete from GXDBVersions where name = 'BuildSubTaskExtOption' and type = 5
END
GO

	CREATE FUNCTION BuildSubTaskExtOption(@taskId integer, @subTaskId integer, @optionType integer )
	RETURNS NVARCHAR(1024)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sOption		VARCHAR(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		SET @count = 0
		SET @sOption = ''
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) value FROM TM_SubTaskOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
									subTaskId = @subTaskId), @bitVal)
			SET @sOption = @sOption + CAST(@bitVal AS CHAR(1))
			SET @count = @count + 1
		END
		RETURN @sOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubTaskExtOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubTaskExtOption' AND revision = '1.4.278.1')

  insert into GXDBVersions values(5, 'BuildSubTaskExtOption',  '1.4.278.1', 'BuildSubTaskExtOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
