

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubClientName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubClientName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubClientName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubClientName]
  delete from GXDBVersions where name = 'BuildSubClientName' and type = 5
END
GO

    CREATE FUNCTION BuildSubClientName (@appTypeID int, @instanceName NVARCHAR(255), @bkpSetName NVARCHAR(255), @subClientName NVARCHAR(255), @status INT = 0, @localeId INT = 0)
    RETURNS NVARCHAR(255)
    -- WITH ENCRYPTION
    AS BEGIN
        RETURN (CASE WHEN     @appTypeID =  2         -- Oracle     -- Instance Applications
                          OR  @appTypeID =  3         -- Informix
                          OR  @appTypeID =  5         -- Sybase
                          OR  @appTypeID =  6         -- Lotus Notes DB
                          OR  @appTypeID = 22         -- Oracle 8
                          OR  @appTypeID = 24         -- Serverless Data Manager
                          OR  @appTypeID = 27         -- FasTrax Exchange DB
                          OR  @appTypeID = 31         -- FasTrax Exchange DB 2000
                          OR  @appTypeID = 32         -- SharePoint DB
                          OR  @appTypeID = 48         -- Serverless Data Manager on Unix
                          OR  @appTypeID = 51         -- UNIX Lotus Notes DB
                          OR  @appTypeID = 59         -- Lotus Notes 6 Database
                          OR  @appTypeID = 61         -- SAP for Oracle
                          OR  @appTypeID = 77         -- Notes 6 Database On Unix
                          OR  @appTypeID = 79         -- SAP for SAPDB
                          OR  @appTypeID = 80         -- Oracle RAC
                          OR  @appTypeID = 81         -- SQL Server
                          OR  @appTypeID = 89         -- Share Point Data Migrator
                          OR  @appTypeID = 104        -- MySQL
                          OR  @appTypeID = 127        -- EDC
                          OR  @appTypeID = 128        -- Documentum
                    THEN  @instanceName + N'\' + @subClientName
                    WHEN  @appTypeID =  4             -- SQL Server     -- Instance & Backupset Applications
                          OR  @appTypeID =  7         -- Lotus Notes Doc
                          OR  @appTypeID = 16         -- SQL Server 2000
                          OR  @appTypeID = 37         -- DB2 (MR #50738)
                          OR  @appTypeID = 52         -- UNIX Lotus Notes Doc
                          OR  @appTypeID = 60         -- Lotus Notes 6 Document
                          OR  @appTypeID = 62         -- Unix DB2 (MR #50738)
                          OR  @appTypeID = 70         -- SQL Server 2005
                          OR  @appTypeID = 89         -- Share Point Data Migrator
                          OR  @appTypeID = 90         -- Lotus Notes Document Data Migrator
                          OR  @appTypeID = 90         -- Lotus Notes Document Data Migrator
                          OR  @appTypeID = 103        -- DB2 DPF
                          OR  @appTypeID = 106        -- VirtualServer
                          OR  @appTypeID = 125        -- Postgress
                          OR  @appTypeID = 130        -- Other AppType
                    THEN  @instanceName + N'\' + @bkpSetName + N'\' + @subClientName
                    WHEN  @appTypeID =  9             -- Exchange Database 5.5 -- Subclient Appcliations
                          OR  @appTypeID = 15         -- Exchange Database 2000
                          OR  @appTypeID = 53         -- Exchange Titanium Database
                          OR  @appTypeID = 65         -- Image Level
                          OR  @appTypeID = 66         -- Unix File System Data Migrator
                          OR  @appTypeID = 67         -- Exchange Archiver
                          OR  @appTypeID = 68         -- Exchange 5.5 Archiver
                          OR  @appTypeID = 25         -- ProxyHost (MR #50352)
                          OR  @appTypeID = 40         -- ProxyHost on Unix (MR #50352)
                          OR  @appTypeID = 47         -- QR Agent (MR #50352)
                          OR  @appTypeID = 50         -- QR Agent on Unix (MR #50352)
                          OR  @appTypeID = 48         -- Serverless Data Manager on Unix (MR #50352)
                          OR  @appTypeID = 71         -- GroupWise DB
                          OR  @appTypeID = 75         -- Image Level On Unix
                          OR  @appTypeID = 76         -- Proxy Host For Image Level
                          OR  @appTypeID = 87         -- Image Level ProxyHost on Unix
                    THEN  @subClientName
                    WHEN  (@appTypeID =  58 AND @status & 0x400 = 0x400) -- Windows File System Data Migrator
                    THEN  (CASE LEN(@instanceName)
                                WHEN 0 THEN N'Local Migration Instance\'+ dbo.SubsArgs0(@localeID, CAST(1644167168 AS BIGINT) | CAST(246 AS BIGINT)) + N'\' + @subClientName
                                ELSE @instanceName + N'\' + dbo.SubsArgs0(@localeID, CAST(1644167168 AS BIGINT) | CAST(246 AS BIGINT)) + N'\' + @subClientName
                            END)
                    WHEN  (@appTypeID =  58 and @status & 0x400 <> 0x400) -- Windows File System Data Migrator
                    THEN  (CASE LEN(@instanceName)
                                WHEN 0 THEN N'Local Migration Instance\Local Migration BackupSet\'+ @subClientName
                                ELSE @instanceName + N'\' + @bkpSetName + N'\' + @subClientName
                           END)
                    WHEN   @appTypeID = 69
                    THEN   N'Databases\' + @subClientName
                    WHEN   @appTypeID = 73
                    THEN   (CASE LEN(@instanceName)
                                 WHEN 0 THEN N'Network Share Instance\Network Share Backupset\'+ @subClientName
                                 ELSE @instanceName + N'\' + @bkpSetName + N'\' + @subClientName
                            END)
                    ELSE  @bkpSetName + N'\' + @subClientName -- Any other AppType
            END)
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubClientName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubClientName' AND revision = '1.2.210.1')

  insert into GXDBVersions values(5, 'BuildSubClientName',  '1.2.210.1', 'BuildSubClientName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
