

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildJobOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildJobOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildJobOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildJobOption]
  delete from GXDBVersions where name = 'BuildJobOption' and type = 5
END
GO

	CREATE FUNCTION BuildJobOption(@jobId bigint, @optionType integer )
	RETURNS BIGINT
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @bitOption		BIGINT
		DECLARE @bitLOption		VARBINARY(MAX)
		DECLARE @bitHOption		VARBINARY(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SET @count = 0
		SET @bitLOption = 0
		SET @bitHOption = 0
		SET @bitOption = 0
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			IF @jobId != 0
			BEGIN
				--SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND jobId = @jobId), @bitVal)
				SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
						(jobId=@jobId OR (jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))), @bitVal)
			END
			IF @bitVal != 0
				IF @count < 31
					SET @bitLOption = @bitLOption + POWER(2, @count)
				ELSE
					SET @bitHOption = @bitHOption + POWER(2, @count-31)
			SET @count = @count + 1
		END
		SET @bitOption = dbo.GetBigIntFromInt(@bitHOption, @bitLOption)
		RETURN @bitOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildJobOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildJobOption' AND revision = '1.11.278.1')

  insert into GXDBVersions values(5, 'BuildJobOption',  '1.11.278.1', 'BuildJobOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
