

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildJobExtOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildJobExtOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildJobExtOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildJobExtOption]
  delete from GXDBVersions where name = 'BuildJobExtOption' and type = 5
END
GO

	CREATE FUNCTION BuildJobExtOption(@jobId bigint, @optionType integer )
	RETURNS NVARCHAR(1024)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sOption		VARCHAR(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SET @count = 0
		SET @sOption = ''
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			IF @jobId != 0
			BEGIN
				--SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND jobId = @jobId), @bitVal)
				SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
						(jobId=@jobId OR (jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))), @bitVal)
			END
			SET @sOption = @sOption + CAST(@bitVal AS CHAR(1))
			SET @count = @count + 1
		END
		RETURN @sOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildJobExtOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildJobExtOption' AND revision = '1.9.278.1')

  insert into GXDBVersions values(5, 'BuildJobExtOption',  '1.9.278.1', 'BuildJobExtOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
