

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildFullEntityName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildFullEntityName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildFullEntityName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildFullEntityName]
  delete from GXDBVersions where name = 'BuildFullEntityName' and type = 5
END
GO

    CREATE FUNCTION BuildFullEntityName (@groupBy INT, @subclientId INT, @status INT = 0, @localeId INT = 0)
    RETURNS NVARCHAR(2048)
    -- WITH ENCRYPTION
    AS BEGIN
        DECLARE @commCellName   NVARCHAR(512) = N''
        DECLARE @clientName     NVARCHAR(512) = N''
        DECLARE @agentName      NVARCHAR(512) = N''
        DECLARE @subclientName  NVARCHAR(512) = dbo.BuildSubClientNameById(@subclientId, @status, @localeId)
        SELECT  @commCellName   = CC.aliasName,
        @clientName     = CL.name,
        @agentName      = IDA.name
        FROM    APP_Application A   INNER JOIN APP_Client CL ON CL.id = A.clientId
                INNER JOIN APP_CommCell CC ON CC.id = A.origCCId
                INNER JOIN APP_iDAType IDA ON IDA.[type] = A.appTypeId
        WHERE A.id = @subclientId
        IF SUBSTRING(@subclientName, 1, LEN(@clientName) + 1) = @clientName + N'\' BEGIN
            -- some subclient names could start with client name.
            SET @subclientName = SUBSTRING(@subclientName, (LEN(@clientName) + 2), LEN(@subclientName))
        END
        DECLARE @fullName      NVARCHAR(2000) = N''
        IF @groupBy = 1 BEGIN               -- client
            SET @fullName = @agentName + N'\' + @subclientName
        END ELSE IF @groupBy = 2 BEGIN      -- agent
            SET @fullName = @commCellName + N'\' + @clientName + N'\' + @subclientName
        END ELSE IF @groupBy = 4 BEGIN      -- client group
            SET @fullName = @commCellName + N'\' + @agentName + N'\' + @clientName + N'\' + @subclientName
        END ELSE BEGIN                          -- commcell, storage, job
            SET @fullName = @clientName + N'\' + + @agentName + N'\' + @subclientName
        END
        RETURN  @fullName
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildFullEntityName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildFullEntityName' AND revision = '1.1.210.1')

  insert into GXDBVersions values(5, 'BuildFullEntityName',  '1.1.210.1', 'BuildFullEntityName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
