

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BackupSummaryFn.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: BackupSummaryFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupSummaryFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BackupSummaryFn]
  delete from GXDBVersions where name = 'BackupSummaryFn' and type = 5
END
GO

	CREATE FUNCTION BackupSummaryFn (
		@treeSelection XML,
		@reportParameters XML,
		@localeId INTEGER,
		@userId	INTEGER,
		@request XML
	)
	RETURNS @bkpJobList	TABLE (
		JobType							INTEGER,		--Use Enum
		ClientId						INTEGER,
		ClientName						NVARCHAR(510),
		AgentTypeId						INTEGER,
		AgentName						VARCHAR(510),
		InstanceId						INTEGER,
		InstanceName					NVARCHAR(1024),
		BackupSetId						INTEGER,
		BackupSetName					NVARCHAR(256),
		SubClientId						INTEGER,
		SubClientName					NVARCHAR(256),
		StoragePolicyId					INTEGER,
		StoragePolicyName				NVARCHAR(510),
		JobId							INTEGER,
		CommcellId						INTEGER,
		CommcellName					NVARCHAR(512),
		Status							INTEGER,
		ScheduleInitiated				INTEGER,
		SubTaskName						NVARCHAR(512),
		TaskName						NVARCHAR(512),
		BackupLevel						INTEGER,
		ScanType						INTEGER,		--Use enum
		StartTime						DATETIME,
		WriteStartTime					DATETIME,
		EndTime							DATETIME,
		WriteEndTime					DATETIME,
		CurrentPhase					VARCHAR(128),
		ApplicationSize					BIGINT,
		CompressionRatePct				FLOAT,
		NwTransBytes					BIGINT,
		SizeOnMedia						BIGINT,
		SpaceSavingsPct					INTEGER,
		DataSizeChange					FLOAT,
		TransferTime					INTEGER,		--Duration
		CurrentTransferTime				INTEGER,		--Duration
		ThroughputGB					FLOAT,
		CurrentThroughputGB				FLOAT,
		ThroughputMB					FLOAT,
		CurrentThroughputMB				FLOAT,
		ProtectedObjects				BIGINT,
		FailedFiles						BIGINT,
		FailedFolders					BIGINT,
		QRDestination					NVARCHAR(510),
		AssociatedMedia					NVARCHAR(510),
		Drive							NVARCHAR(510),
		MediaAgent						NVARCHAR(510),
		ClientGroup						NVARCHAR(510),
		UserName						NVARCHAR(1024),
		RetainedUntil					DATETIME,
		RetainedBy						INTEGER,		--Use enum (Basic/Extended/NA)
		IsAged							INTEGER,		--Use enum (Yes/No/NA)
		IsMediaDeleted					INTEGER,		--Use enum (Yes/No/NA)
		IsBackupCopyJob					INTEGER,		--Use enum (Yes/No/NA)
		IsSnapBackup					INTEGER,		--Use enum (Yes/No/NA)
		IsPerformanceJob				INTEGER,		--Use enum (Yes/No/NA)
		QROperationType					INTEGER,		--Use enum (Incremental Update/Snapshot/Quick Recovery Agent Volume Creation/NA
		ScanTypeChangeReason			NVARCHAR(MAX),
		FailureReason					NVARCHAR(MAX),
		JobDesc							NVARCHAR(4000),
		ClientDesc						NVARCHAR(4000),
		AgentDesc						NVARCHAR(4000),
		BackupSetDesc					NVARCHAR(4000),
		InstanceDesc					NVARCHAR(4000),
		SubClientDesc					NVARCHAR(4000),
		Events							NVARCHAR(MAX),
		JobAttempts						NVARCHAR(MAX),

		SCContentFilters				NVARCHAR(MAX),
		ProtectedObjectsList			NVARCHAR(MAX),
		FailedObjectsList				NVARCHAR(MAX),
		ContentIndexingFailures			NVARCHAR(MAX),
		StubbedFilesList				NVARCHAR(MAX),
		LogDetails						NVARCHAR(MAX),
		JobDetails						NVARCHAR(MAX)
	)
	AS
	BEGIN
		DECLARE @MAXINT	integer
		SET	@MAXINT	= 0x7FFFFFFF

		DECLARE @startTime		integer
		DECLARE @endTime		integer
		DECLARE @rangetype		integer

		DECLARE @isAssocMediaSelected	INTEGER
		DECLARE @isClientGroupSelected	INTEGER
		DECLARE @RetainedUntilSelected	INTEGER
		DECLARE @RetainedBySelected		INTEGER
		DECLARE @AssocEventsSelected	INTEGER
		DECLARE @JobAttemptsSelected	INTEGER

		SET @isAssocMediaSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658418)
		SET @isClientGroupSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658421)
		SET @RetainedUntilSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658423)
		SET @RetainedBySelected		= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658424)
		SET @AssocEventsSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658439)
		SET @JobAttemptsSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658440)

		SET @startTime = 0
		SET @endTime = 0
		SELECT @startTime = dbo.GetUnixTime(ISNULL(item.c.value('./@value', 'DATETIME'), dbo.GetDateTime(0)))
			FROM @reportParameters.nodes('/Parameters/PC_Cell') item(c)
			WHERE ISNULL(item.c.value('./@type', 'INT'),0) = 7
		SELECT @endTime = dbo.GetUnixTime(ISNULL(item.c.value('./@value', 'DATETIME'), dbo.GetDateTime(0)))
			FROM @reportParameters.nodes('/Parameters/PC_Cell') item(c)
			WHERE ISNULL(item.c.value('./@type', 'INT'),0) = 8

		DECLARE @tblApplication		TABLE (id INT, clientId INT, appTypeId INT, instance INT, subclientStatus INT, dataArchGrpId INT, logArchGrpId INT)
		DECLARE @selectedIds TABLE (id INT)

		IF EXISTS ( SELECT item.c.value('./@_type_', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/subclientFilterList') item(c))
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	* FROM dbo.GetSelectedSubClients(@treeSelection)

			INSERT	INTO @tblApplication
			SELECT	DISTINCT A.id, clientId, appTypeId, instance, subClientStatus, dataArchGrpID, logArchGrpID
			FROM	APP_Application A, @selectedIds S
			WHERE	A.id = S.id
		END
		ELSE IF EXISTS ( SELECT item.c.value('./@clientGroupId', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/Items') item(c)
						WHERE	ISNULL(item.c.value('./@clientGroupId', 'INT'),0) = 0)
		BEGIN
			INSERT INTO @selectedIds(id)
			SELECT	item.c.value('./@clientId', 'int') as id
			FROM @treeSelection.nodes('/TreeSelections/Items') item(c)

			INSERT	INTO @tblApplication
			SELECT	DISTINCT A.id, clientId, appTypeId, instance, subClientStatus, dataArchGrpID, logArchGrpID
			FROM	APP_Application A, @selectedIds S
			WHERE	A.clientId = S.id OR S.id = -1
		END
		ELSE IF EXISTS ( SELECT item.c.value('./@clientGroupId', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/Items') item(c)
						WHERE	ISNULL(item.c.value('./@clientGroupId', 'INT'),0) <> 0)
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	item.c.value('./@clientGroupId', 'int') as id
			FROM	@treeSelection.nodes('/TreeSelections/Items') item(c)

			INSERT	INTO @tblApplication
			SELECT	DISTINCT A.id, A.clientId, appTypeId, instance, subClientStatus, dataArchGrpId, logArchGrpId
			FROM	APP_Application A, APP_ClientGroupAssoc CG, @selectedIds S
			WHERE	(A.clientId = CG.clientId AND CG.clientGroupId = S.id) OR S.id = -1
		END

		DELETE FROM @selectedIds
		IF EXISTS ( SELECT	item.c.value('./@include', 'INT')
						FROM	@treeSelection.nodes('/TreeSelections/agentList/flags') item(c)
						WHERE	item.c.value('./@include', 'INT') = 1)
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	DISTINCT apptypeId FROM APP_IDAName
		END
		ELSE
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	item.c.value('./@applicationId', 'INT') as id
			FROM	@treeSelection.nodes('/TreeSelections/agentList') item(c)
		END
		IF NOT EXISTS ( SELECT item.c.value('./@_type_', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/subclientFilterList') item(c))
			DELETE	FROM @tblApplication
			WHERE	appTypeId NOT IN (SELECT DISTINCT id FROM @selectedIds)

		DECLARE @descTbl			TABLE (cJobid INT, cellId INT, cJobDesc nvarchar(MAX), xJobInfo nvarchar(MAX))


		DECLARE @BKPXT TABLE(
			ccId	INT,
			jobId	INT,
			optype	INT,
			clId	INT,
			appId	INT,
			appType	INT,
			bLevel	INT,
			status	INT,
			state	INT,
			startT	INT,
			endT	INT,
			duration INT,
			cPhase	INT,
			objects	BIGINT,
			uncompSize	BIGINT,
			bTime	INT,
			initF	INT,
			failIds	varchar(512),
			failR	ntext,
			sFl	INT,
			sFd	INT,
			bFl	INT,
			bFd	INT,
			options	INT,
			attributes	BIGINT,
			userName	nvarchar(1024),
			archGrp	INT,
			logArchGrp INT,
			wST 	INT,
			wET 	INT,
			failError	INT,
			cIdx	BIGINT	default(0),
			scanType	INT	default(0),
			scanChangeReason	varchar(1024) default(''),
			compSize	BIGINT,
			bkpSize	BIGINT,
			percChange	INT,
			jobDescription nvarchar(MAX) default(N''),
			xmlJobInfo nvarchar(MAX) default(N''),
			snapJobId	INT,
			snapJobStatus	INT,
			dataStatus		INT,
			agedTime		INT,
			transferredDataSize BIGINT default(-1),
			sizeOnMedia		BIGINT,
			t_subTaskId		INT
		)


		INSERT INTO @BKPXT
		SELECT 2, J.jobId, J.optype, A.clientId, A.id, appTypeId, bkpLevel, 0, state, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase, filesXfered, uncompbytes,
			isnull((select sum(writeTime) from JMBkpAttemptInfo WITH (READUNCOMMITTED) where JMBkpAttemptInfo.jobId=J.jobId), 0)+isnull((select max(writeTime) from JMJobStreams WITH (READUNCOMMITTED) where jobId=J.jobId), 0),
			initFrom, failureReason, dbo.JMGetLocalizedMessageFunc(@localeId, failureReason), scanFileFailures, scanFolderFailures, backupFileFailures,
			backupFolderFailures, bkpOptions, bkpAttributes,
			(select login from UMUsers where id=userId), currentPolicy, 0, 0, 0, 0, 0, scanType, scanTypeChangeReason, compbytes, compbytes, 0, J.jobDescription, J.xmlJobInfo, 0, 0, -1, -1, -1, 0, B.backupTaskId
		FROM	JMJobInfo J WITH (READUNCOMMITTED), JMBkpJobInfo B WITH (READUNCOMMITTED), @tblApplication A
		WHERE	J.commcellId=B.commcellId and J.jobId=B.jobId and applicationId=A.id AND
			(@endTime = 0 OR jobStartTime <= @endTime)

		UPDATE @BKPXT
		SET	wst=(select top 1 A.startTime
			FROM	JMBkpAttemptInfo A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phaseNum=J.phaseNum and A.attemptNum=J.attemptNum
			ORDER BY A.phaseNum, A.attemptNum)
		FROM	@BKPXT T

		INSERT INTO @descTbl
		SELECT	J.jobid, J.commcellId, J.jobDescription, J.xmlJobInfo
		FROM	JMJobStats J WITH (READUNCOMMITTED)
				INNER JOIN JMBkpStats B
					ON J.jobId = B.jobID AND J.commcellId = B.commcellId
		WHERE	(@startTime = 0 OR B.servEndDate >= @startTime) AND (@endTime = 0 OR B.servStartDate <= @endTime)

		INSERT INTO @BKPXT
		SELECT commcellId,jobId,optype,clientId,appId,appType,bkpLevel,(case displayStatus when 0 then status else displayStatus end),0,servStartDate,servEndDate,duration,0,
			totalNumOfFiles,totalUncompbytes,totalWriteTime,initFrom,failureReason,dbo.JMGetLocalizedMessageFunc(@localeId,failureReason),
			scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,bkpOptions,bkpAttributes,userName,
			J.dataArchGrpId, J.logArchGrpId,0,0,failureErrorCode,0,
			scanType,scanTypeChangeReason,totalcompbytes,totalBackupSize,percentageChange,
			cJobDesc , xJobInfo , 0, 0, J.dataStatus,J.agedTime, J.nwTransBytes, 0, J.subTaskId
		FROM	JMBkpStats J
				LEFT JOIN @descTbl
					ON cjobId = J.jobId and cellId =J.commcellId
				INNER JOIN APP_Application A
					ON	A.id = J.appId
		WHERE (@startTime = 0 OR J.servEndDate >= @startTime) AND (@endTime = 0 OR J.servStartDate <= @endTime)

		UPDATE @BKPXT
		SET	wst=(select top 1 A.servStartDate
			FROM	JMBkpAtmptStats A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phase=J.phaseNum and A.number=J.attemptNum
			ORDER BY A.phase, A.number)
		FROM	@BKPXT T

		UPDATE @BKPXT
		SET	wet=(select top 1 A.servEndDate
			FROM	JMBkpAtmptStats A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phase=J.phaseNum and A.number=J.attemptNum
			ORDER BY A.phase DESC, A.number DESC)
		FROM	@BKPXT T


		INSERT INTO @BKPXT
		SELECT	Q.commcellId, Q.jobId, A.opType, Q.clientId, -1, 1115 /*apptype*/, 0,
				A.status, 0, A.servStart, A.servEnd, (A.servEnd - A.servStart), 0,
				A.numFiles, A.uncompBytes, A.totalWriteTime, A.initFrom, A.failureReason, dbo.JMGetLocalizedMessageFunc(@localeId, failureReason),
				0, 0, 0, 0, 0, 0, A.username,
				(CASE A.archGrpId WHEN 0 THEN -1 ELSE A.archGrpId END), 0, 0, 0, A.failureErrorCode, 0,
				0, '', 0, 0, 0,
				'', N'', 0, 0, A.dataStatus, -1, -1, 0, A.subTaskId
		FROM	JMQinetixUpdateStatus Q WITH (READUNCOMMITTED), JMAdminJobStatsTable A WITH (READUNCOMMITTED)
		WHERE	Q.jobId = A.jobId AND
				Q.commcellId = A.commcellID AND
				A.opType = 79 AND
				(@startTime = 0 OR A.servEnd >= @startTime) AND (@endTime = 0 OR A.servStart <= @endTime) AND
				Q.clientId > 0

		DELETE @BKPXT
		WHERE clId NOT IN (SELECT DISTINCT clientId FROM SRM..SRMSECGetCSUserObjectsFN(@userId))

		UPDATE	@BKPXT
		SET		appType = 33
		WHERE	appType in (1, 11, 34, 42, 43)

		INSERT INTO	@bkpJobList
		(	JobType, ClientId, ClientName, AgentTypeId, AgentName, InstanceId, InstanceName,
			BackupSetId, BackupSetName, SubClientId, SubClientName, StoragePolicyId, StoragePolicyName,
			JobId, CommcellId, Status, ScheduleInitiated, SubTaskName, TaskName, BackupLevel, ScanType, StartTime, WriteStartTime, EndTime, WriteEndTime,
			CurrentPhase, ApplicationSize, CompressionRatePct, NwTransBytes, SizeOnMedia, SpaceSavingsPct, DataSizeChange, TransferTime,
			CurrentTransferTime, ThroughputGB, CurrentThroughputGB, ThroughputMB, CurrentThroughputMB, ProtectedObjects, FailedFiles, FailedFolders,
			QRDestination, AssociatedMedia, Drive, MediaAgent, ClientGroup, UserName, RetainedUntil, RetainedBy,
			IsAged, IsMediaDeleted, IsBackupCopyJob, IsSnapBackup, IsPerformanceJob, QROperationType, ScanTypeChangeReason, FailureReason,
			JobDesc, ClientDesc, AgentDesc, BackupSetDesc, InstanceDesc, SubClientDesc,
			Events, JobAttempts, SCContentFilters, ProtectedObjectsList, FailedObjectsList, ContentIndexingFailures,
			StubbedFilesList, LogDetails, JobDetails
		)
		SELECT
		dbo.GetBkpJobReportType(appType), clId, (select name from APP_Client WITH (READUNCOMMITTED) where id=clId),
		appType, (select name from APP_iDAType WITH (READUNCOMMITTED) where type=appType),
		instance, (select dbo.GetInstanceName(APP_InstanceName.name, appType) from APP_InstanceName WITH (READUNCOMMITTED) where id=instance),
		(SELECT backupSet FROM APP_Application WHERE id = appId),(select name from APP_BackupSetName WITH (READUNCOMMITTED) where id=(SELECT backupSet FROM APP_Application WHERE id = appId)),
		appId,(SELECT subClientName FROM APP_Application WHERE id = appId), archGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=archGrp),''),
		JobId, ccId, dbo.GetBkpJobStatus(status, state),
		CASE WHEN initF = 3 /*SCHEDINITIATED*/ THEN 1 ELSE 0 END,
		CASE WHEN initF = 3 THEN (SELECT subTaskName FROM TM_SubTask WHERE subTaskId = t_subTaskId) ELSE N'' END, --Sub task Name
		CASE WHEN initF = 3 THEN (SELECT taskName FROM TM_Task WHERE taskId = (SELECT taskId FROM TM_SubTask WHERE subTaskId = t_subTaskId)) ELSE N'' END, --Task Name
		bLevel,
		dbo.GetScanType(scanType), CASE WHEN startT <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(startT, 0)) END,
		CASE WHEN wST <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(wST, 0)) END,
		CASE WHEN endT <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(endT, 0)) END,
		CASE WHEN wET <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(wET, 0)) END,
		(CASE cPhase
			WHEN 0 THEN 'N/A'
			ELSE (SELECT name FROM JMPhase P WITH (READUNCOMMITTED), JMOpTable O WITH (READUNCOMMITTED) WHERE O.appTypeType=appType AND O.operation=optype AND P.opTableId=O.id AND P.phase=cPhase)
		END),
		uncompSize, dbo.GetCompressionRate(uncompSize, compSize), transferredDataSize, dbo.GetSizeOnMedia(jobId, ccid),
		dbo.GetSpaceSavingPct(uncompSize, jobId, ccid, optype, status), percChange, bTime, dbo.GetCurrentTransferTime(jobId, ccid, status),
		dbo.GetThroughput(uncompSize, btime, 1 /*GB/Hour */), dbo.GetThroughput(dbo.GetCurrentSize(jobId, ccid, status), dbo.GetCurrentTransferTime(jobId, ccid, status), 1 /*GB/Hour */),
		dbo.GetThroughput(uncompSize, bTime, 2/*MB/Sec*/), dbo.GetThroughput(dbo.GetCurrentSize(jobId, ccid, status), dbo.GetCurrentTransferTime(jobId, ccid, status), 2 /*MB/Sec */),
		objects, (sFl+bFl), (sFd+bFd), dbo.GetQRDestination(jobId, ccid),
		CASE WHEN @isAssocMediaSelected <> 0 THEN dbo.GetAssociatedMedia(jobId, ccid, opType) ELSE '' END, dbo.GetDriveByJobId(jobId),
		dbo.GetMediaAgent(jobId, ccId),
		CASE WHEN @isClientGroupSelected <> 0 THEN dbo.GetClientGroup(clId) ELSE '' END, userName, dbo.GetDateTime(0), 1, --retention time and type will be updated later
		0, 0, 0, 0, 0,
		999, scanChangeReason, failR, jobDescription, '',
		'', '', '', '',
		CASE WHEN @AssocEventsSelected <> 0 THEN dbo.GetAssociatedEvents(jobId, ccId, @localeId) ELSE '' END, '', '', '', '', '', '', '', ''
		FROM	@BKPXT, @tblApplication WHERE appId = id


		--Retention details
		IF (@RetainedUntilSelected <> 0 OR @RetainedBySelected <> 0)
		BEGIN
		DECLARE @tempJobRetention TABLE(
			jobId INT, commCellId INT, archGrpCopyId INT,
			retentionDays INT, extRetentionFlags INT, extRetentionDays INT,
			manualRetentionEndTime BIGINT, manualRetaided INT,
			PRIMARY KEY(jobId, commCellId, archGrpCopyId))

		DECLARE @maxJobRetention TABLE(
			jobId INT, commCellId INT, extRetentionFlags INT, retentionDays BIGINT, extRetentionDays BIGINT, manualRetentionEndTime BIGINT,
			PRIMARY KEY(jobId, commCellId))


		INSERT INTO @tempJobRetention
		SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
					(case when J.AppType in (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE isDMAppType = 1)
						 then A.archiverRetDays else A.retentionDays end),
					B.retentionFlags, 0,
					B.manualRetentionEndTime, B.disabled & 2
		FROM	JMJobDataStats B WITH (NOLOCK), @BKPXT J,
					(SELECT AR.copyId,
							(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays,
							(case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end) AS archiverRetDays
					FROM	archAgingRule AR WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
					WHERE	AR.copyId = AGC.id ) A
		WHERE	B.commCellId = J.ccId AND B.jobId = J.jobId
				AND B.status IN (2, 100)
				AND A.copyId = B.archGrpCopyId
				AND J.appId = B.appId

		UPDATE	@tempJobRetention
		SET		extRetentionFlags = (
					case
					when extRetentionFlags & 64 <> 0 then 64
					when extRetentionFlags & 32 <> 0 then 32
					when extRetentionFlags & 16 <> 0 then 16
					when extRetentionFlags & 8 <> 0 then 8
					when extRetentionFlags & 4 <> 0 then 4
					when extRetentionFlags & 2 <> 0 then 2
					end)
		WHERE	extRetentionFlags <> 0

		UPDATE	@tempJobRetention
		SET		extRetentionDays = b.retentionDays
		FROM	@tempJobRetention a,
					(SELECT AR.copyId, AR.retentionRule,
					(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays
					FROM	archAgingRuleExtended AR WITH (READUNCOMMITTED), archGroupCopy AGC WITH (NOLOCK)
					WHERE	AR.copyId = AGC.id ) b
		WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.extRetentionFlags

		INSERT INTO @maxJobRetention
		SELECT	jobId, commCellId, MAX(extRetentionFlags), MAX(retentionDays), MAX(extRetentionDays), MAX(manualRetentionEndTime)
		FROM	@tempJobRetention
		GROUP BY jobId, commCellId


		UPDATE	@bkpJobList
		SET		RetainedUntil =
				(CASE	WHEN R.retentionDays = @MAXINT THEN dbo.GetDateTime(-1)
						WHEN R.manualRetentionEndTime = -1 THEN dbo.GetDateTime(0)
						WHEN (dbo.GetUnixTime(B.StartTime) + (R.retentionDays * 60 * 60 * 24)) < R.manualRetentionEndTime
							THEN dbo.GetDateTimeBIG(R.manualRetentionEndTime)
						WHEN (dbo.GetUnixTime(B.StartTime) + (R.retentionDays * 60 * 60 * 24)) >= R.manualRetentionEndTime
							THEN dbo.GetDateTimeBIG(dbo.GetUnixTime(B.StartTime) + (R.retentionDays * 60 * 60 * 24))
						ELSE
							dbo.GetDateTime(0)
				END)
		FROM	@maxJobRetention R, @bkpJobList B
		WHERE	R.jobId = B.jobId AND R.commcellId = B.commcellId

		UPDATE	@bkpJobList
		SET		RetainedBy =
				(CASE	WHEN R.extRetentionFlags > 0 THEN 2	--EXTENDED RETENTION
						ELSE 1								--BASIC RETENTION
				END)
		FROM	@maxJobRetention R, @bkpJobList B
		WHERE	R.jobId = B.jobId AND R.commcellId = B.commcellId
		END

		--Aged
		UPDATE	@bkpJobList
		SET		IsAged = 1
		FROM	JMBkpStats J WITH (READUNCOMMITTED), @bkpJobList B
		WHERE	B.jobId=J.jobId and B.CommcellId = J.commcellId and J.dataStatus=1 AND B.status NOT IN (2, 4, 9)	--(FAIL, KILLED, DROPPED)

		--MediaDeleted
		UPDATE	@bkpJobList
		SET		IsMediaDeleted = 1
		FROM	JMBkpStats J WITH (READUNCOMMITTED), @bkpJobList B
		WHERE	B.jobId=J.jobId and B.CommcellId=J.commcellId and J.dataStatus=2 AND B.status IN (1, 3)	-- JMSUCCESS, PARTIALSUCCESS
			AND B.AgentTypeId NOT IN (SELECT appTypeId FROM APP_IDATypeHandlingInfo  WITH (READUNCOMMITTED) WHERE isDMAppType = 1)


		--BackupCopyJob
		UPDATE	@bkpJobList
		SET		IsBackupCopyJob = 1
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId AND opType = 60  --SNAPTOTAPE


		--Snap Backup jobs
		UPDATE	@bkpJobList
		SET		IsSnapBackup = 1
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId AND opType = 59  --SNAPBACKUP

		--Performance Jobs
		UPDATE	@bkpJobList
		SET		IsPerformanceJob = 1
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId
			AND dbo.GetOptionInt(312685036, B.jobId, 0, 0) = 1

		--QROperationType
		UPDATE	@bkpJobList
		SET		QROperationType = (
				CASE WHEN opType = 22 THEN 1 -- Create Snapshot
					WHEN opType = 23 THEN 2 -- Quick Recovery Agent Volume Creation
					WHEN optype = 24 THEN 3 -- Update Snapshot
					ELSE 999 --N/A
				END)
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId

		--Update description fields
		UPDATE @bkpJobList
		SET ClientDesc = ISNULL((SELECT clientDescription FROM APP_Client WITH (READUNCOMMITTED) WHERE id= T.ClientId and T.ClientId> 0),N''),
			AgentDesc = ISNULL((SELECT attrVal FROM APP_IDAProp WITH (READUNCOMMITTED) WHERE componentNameId = (select id from APP_IDAName where clientId= T.ClientId and appTypeId = T.AgentTypeId and T.ClientId>0) AND attrName ='IDA Description' and modified =0),N''),
			BackupSetDesc = ISNULL((SELECT attrVal FROM APP_BackupSetProp WITH (READUNCOMMITTED) WHERE componentNameId= T.BackupSetId and T.BackupSetId> 0 AND attrName ='User Description' and modified =0),N''),
			InstanceDesc = ISNULL((SELECT attrVal FROM APP_InstanceProp WITH (READUNCOMMITTED) WHERE componentNameId= T.InstanceId and T.InstanceId> 0 AND attrName ='User Description' and modified =0),N''),
			SubClientDesc = ISNULL((SELECT attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE componentNameId= T.SubClientId and T.SubClientId > 0 AND attrName ='User Description' and modified =0),N''),
			CommcellName = ISNULL((SELECT aliasName FROM APP_CommCell WHERE id = T.CommcellId), N'')
		FROM @bkpJobList T
		RETURN

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BackupSummaryFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BackupSummaryFn' AND revision = '1.14.48.1')

  insert into GXDBVersions values(5, 'BackupSummaryFn',  '1.14.48.1', 'BackupSummaryFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
