

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BackupStrikes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BackupStrikes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupStrikes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BackupStrikes]
  delete from GXDBVersions where name = 'BackupStrikes' and type = 5
END
GO

 CREATE FUNCTION BackupStrikes (
	@BackupWindowFrom	VARCHAR(32),
	@CountSynthFull		INTEGER
	)
 RETURNS @Results TABLE (
 	StrikeCounts	INT,
	CommServer		NVARCHAR(256),
	ClientGroups	NVARCHAR(1024),
	Client			NVARCHAR(256),
 	Agent			NVARCHAR(256),
 	Instance		NVARCHAR(256),
 	Backupset		NVARCHAR(256),
 	Subclient		NVARCHAR(256),
 	BackupType		NVARCHAR(32),
 	FailedFrom		NVARCHAR(32),
 	FailedDays		INT,
 	LastJobID		INT,
 	LastJobStart	NVARCHAR(32),
 	LastJobEnd		NVARCHAR(32),
	TimeZone		NVARCHAR(256),
 	LastJobStatus	NVARCHAR(32),
	FailureMsgIds	NVARCHAR(256),
 	FailureReason	NVARCHAR(MAX)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @dtCurrWindowBegin DATETIME= DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), @BackupWindowFrom)
 IF		 @dtCurrWindowBegin < GETDATE()
	 SET @dtCurrWindowBegin = DATEADD(DAY, 1, @dtCurrWindowBegin)
 SET	 @dtCurrWindowBegin = dbo.ClientLocalToUTCTime(@dtCurrWindowBegin, 2)
 DECLARE @CurrWindowEnd	INT = dbo.GetUnixTime(DATEADD(DAY, 1, @dtCurrWindowBegin))
 DECLARE @hms INT = DATEPART(HOUR, @dtCurrWindowBegin)*3600 +  DATEPART(MINUTE, @dtCurrWindowBegin)*60 + DATEPART(SECOND, @dtCurrWindowBegin)

 DECLARE @TblFailedApp TABLE (vmClientId INT, appId INT, backupType INT, lastSuccJobTime INT, firstFailedJobStart DATETIME, lastFailedJobId INT, lastFailedJobTime INT)

 INSERT INTO @TblFailedApp
 SELECT	0, appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, NULL, MAX(jobId), 0
 FROM	JMBkpStats
 WHERE	(bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND status NOT IN (1, 14) AND failureErrorCode <> 8
 	AND (status <> 3 OR appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND commCellId = 2
  	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700 AND appType <> 106
 GROUP BY appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 INSERT INTO @TblFailedApp
 SELECT JMQ.clientId, 0, CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, NULL, MAX(J.jobId), 0
 FROM	JMQinetixUpdateStatus JMQ
 		INNER JOIN JMBkpStats J
 				ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
 		INNER JOIN APP_VMProp V
 				ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId
 				AND JMQ.clientId = V.VMclientId AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
 		INNER JOIN APP_Application A ON J.appId = A.id AND J.appId <> 0
 AND	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1 AND ( A.subclientStatus & (16|32|4|2) =0)
 AND    J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76)
  	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
 GROUP BY JMQ.clientId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 UPDATE @TblFailedApp
 SET	lastFailedJobTime = J.servStartDate
 FROM	@TblFailedApp F INNER JOIN JMBkpStats J ON J.jobId = F.lastFailedJobId AND J.commCellId = 2

 DELETE	@TblFailedApp
 FROM	@TblFailedApp F INNER JOIN APP_Application A ON F.appId = A.id AND F.appId <> 0
 WHERE	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 0
	OR A.dataArchGrpId <= 1 AND A.logArchGrpId <= 1
	OR (A.subclientStatus & (2 | 4)) > 0
	OR A.id IN (SELECT componentNameId FROM APP_subclientProp WHERE attrName = 'DDB Backup' AND attrVal <> '0' AND modified = 0)
	OR A.clientId IN (SELECT componentNameId FROM APP_ClientProp WHERE attrName = 'Content Index Server' AND attrVal = '1')
	OR EXISTS (SELECT * FROM JMJobAction WHERE opType = 4 AND action = 1
		AND (clientId = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0
			OR clientId = A.clientId AND appType IN (A.appTypeId, 0) OR appId = A.id))
	OR EXISTS (SELECT * FROM JMJobAction J INNER JOIN APP_ClientGroupAssoc CGA
		ON CGA.clientGroupId = J.clientGroupId AND CGA.clientId = A.clientId
		AND J.opType = 4 AND J.action = 1 AND J.clientGroupId > 0 AND J.clientId = 1 AND J.appType = 0 AND J.appId = 1)

 DECLARE @TblLastSuccJob TABLE (vmClientId INT, appId INT, backupType INT, jobId INT, startTime INT, backupLevel INT)

 INSERT INTO @TblLastSuccJob
 SELECT	0, F.appId, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END), MAX(J.jobId), 0, 0
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 14) OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND J.commCellId = 2
 GROUP BY F.appId, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END)

 INSERT INTO @TblLastSuccJob
 SELECT F.vmClientId, 0, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END), Max(J.jobId), 0, 0
 FROM	JMQinetixUpdateStatus JMQ
 		INNER JOIN @TblFailedApp F
 				ON F.vmClientId = JMQ.clientId AND F.vmClientId > 0
 		INNER JOIN JMBkpStats J
 				ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId AND F.appId = 0
 		INNER JOIN APP_VMProp V
 				ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId AND JMQ.clientId = V.VMclientId
 				AND V.attrName = 'vmStatus' AND V.attrVal IN ('0', '3')
 		INNER JOIN APP_Application A ON J.appId = A.id AND J.appId <> 0
 AND	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1 AND ( A.subclientStatus & (16|32|4|2) =0)
 AND    J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 3, 14)) --OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76)
 GROUP BY F.vmClientId, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END)

 UPDATE @TblLastSuccJob
 SET	startTime = J.servStartDate, backupLevel = J.bkpLevel
 FROM	@TblLastSuccJob S INNER JOIN JMBkpStats J ON J.jobId = S.jobId AND J.commCellId = 2

 DELETE @TblFailedApp
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId
  WHERE	F.lastFailedJobTime <= S.startTime AND S.backupType IN (1, F.backupType)

 UPDATE @TblFailedApp
 SET appId = J.appId FROM @TblFailedApp F INNER JOIN JMBkpStats J ON F.lastFailedJobId = J.jobId WHERE F.appId = 0

 UPDATE @TblLastSuccJob
 SET appId = J.appId FROM @TblLastSuccJob S INNER JOIN JMBkpStats J ON S.jobId = J.jobId WHERE S.appId = 0

 UPDATE @TblFailedApp
 SET	lastSuccJobTime = S.startTime
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId AND F.backupType = S.backupType

 UPDATE @TblFailedApp
 SET	lastSuccJobTime = FF.startTime
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId
 WHERE	F.backupType = 2 AND FF.backupType = 1 AND F.lastSuccJobTime < FF.startTime
 	AND (@CountSynthFull = 0 OR FF.backupLevel NOT IN (64, 128, 16384))

 DECLARE @TblFirstFailedJob	TABLE (vmClientId INT, appId INT, backupType INT, startTime INT)

 INSERT INTO @TblFirstFailedJob
 SELECT	0, F.appId, F.backupType, MIN(J.servStartDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND J.commCellId = 2
  	AND J.servStartDate > F.lastSuccJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblFirstFailedJob
 SELECT	F.vmClientId, J.appId, F.backupType, MIN(J.servStartDate)
 FROM	JMBkpStats J
		INNER JOIN @TblFailedApp F
				ON J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
		INNER JOIN APP_VMProp V
 				ON V.jobId = J.jobId AND V.commCellId = J.commCellId
 			AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
	AND J.appType = 106 AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND J.commCellId = 2
 	AND J.servStartDate > F.lastSuccJobTime
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblFailedApp
 SET	firstFailedJobStart = dbo.GetDateTime(FF.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblFirstFailedJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId AND F.backupType = FF.backupType

 DECLARE @TblStrikes TABLE (
		vmClientId INT, appId INT, backupType INT, failedFrom DATETIME, failedDays INT,
		lastJobId INT, lastJobStartTime DATETIME, lastJobEndTime DATETIME, lastJobStatus INT, failureReason VARCHAR(MAX))

 INSERT INTO @TblStrikes
 SELECT	F.vmClientId, F.appId, F.backupType, F.firstFailedJobStart,
 		DATEDIFF(DAY, F.firstFailedJobStart, @dtCurrWindowBegin) +
 		CASE WHEN ( DATEPART(HOUR,   F.firstFailedJobStart)*3600 +
 					DATEPART(MINUTE, F.firstFailedJobStart)*60 +
 					DATEPART(SECOND, F.firstFailedJobStart) ) > @hms
 		THEN -1 ELSE 0 END,
		J.jobId, dbo.GetDateTime(J.servStartDate), dbo.GetDateTime(J.servEndDate), J.status, J.failureReason
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.jobId = F.lastFailedJobId AND J.commCellId = 2

 DECLARE @tblFailureMsgIds TABLE (jobId INT, messageId INT, JPR varchar(20), failureReasonTime INT)

 INSERT INTO @tblFailureMsgIds
 SELECT	M.jobId, M.messageId, DBO.GetJPRFromMsgId(M.messageId), MAX(M.failureReasonTime) AS maxFailureReasonTime
 FROM	JMFailureReasonMsg M INNER JOIN @TblStrikes S
 	ON	M.jobId = S.lastJobId AND M.commCellId = 2 AND S.vmClientId = 0
 GROUP BY M.jobId, M.messageId
 ORDER BY M.jobId, maxFailureReasonTime DESC
 DECLARE @NewLine char(1)
 SET @NewLine=char(10)
 DECLARE @NewLine2 char(1)
 SET @NewLine2=char(13)
 DECLARE @BR char(4)
 SET @BR='<BR>'
 INSERT INTO @Results
 SELECT	CASE WHEN F.failedDays = 0 THEN 1 WHEN F.failedDays > 3 THEN 3 ELSE F.failedDays END AS StrikeCounts,
 		@csName AS CommServer,
 		ISNULL(CG.ClientGroups, '') AS ClientGroups,
 		CASE WHEN F.vmClientId = 0 THEN CL.name ELSE (SELECT name FROM APP_Client WHERE id = F.vmClientId) END AS Client,
 		IDA.name + CASE WHEN (A.appTypeId <> 106 OR ISNULL(A.id, 0) = 0) THEN ''
			ELSE ISNULL((SELECT ' in ' + name FROM APP_Client WITH (NOLOCK) WHERE id = A.clientId), '')
			END AS Agent,
 		dbo.FixInstanceName(INS.name, A.appTypeId) AS Instance,
 		B.name AS Backupset,
 		A.subclientName AS Subclient,
 		CASE WHEN F.backupType = 1 THEN 'Full' ELSE 'NonFull' END AS BackupType,
 		dbo.UTCToLocalStringTime(F.failedFrom, @csTimeZone) AS FailedFrom,
 		F.failedDays AS FailedDays,
 		F.lastJobId AS LastJobID,
 		dbo.UTCToLocalStringTime(F.lastJobStartTime, @csTimeZone) AS LastJobStart,
 		dbo.UTCToLocalStringTime(F.lastJobEndTime, @csTimeZone) AS LastJobEnd,
 		@csTimeZone AS TimeZone,
 		dbo.GetJobStatusName(F.lastJobStatus) AS LastJobStatus,
 		ISNULL((SELECT JPR + ' ; ' FROM @tblFailureMsgIds
 				WHERE jobId = F.lastJobId FOR XML PATH('')), '') AS FailureMsgIds,
 		CASE WHEN F.failureReason = '' THEN (Select V.attrVal FROM APP_VMProp V WHERE V.VMclientId = F.vmClientId AND F.lastJobId = V.jobId AND V.attrName = 'vmFailureReason')
 			ELSE (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(LEFT(dbo.JMGetLocalizedMessageFunc(0, F.failureReason),1022),',',' '),@NewLine,';'),@NewLine2,';'),'''',' '),@BR,'')) END AS FailureReason
 FROM	@TblStrikes F
 		INNER JOIN APP_Application A ON A.id = F.appId
 		LEFT OUTER JOIN ClientGroupsStringView CG ON A.clientId = CG.ClientId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IDA ON IDA.type = A.appTypeId
 		INNER JOIN APP_InstanceName INS ON INS.id = A.instance
 		INNER JOIN APP_BackupSetName B ON B.id = A.backupSet
 ORDER BY StrikeCounts, ClientGroups, Client, Agent, Instance, Backupset, Subclient, BackupType

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BackupStrikes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BackupStrikes' AND revision = '1.15')

  insert into GXDBVersions values(5, 'BackupStrikes',  '1.15', 'BackupStrikes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
