

--  ------------  Generated from [../../../Source/CommServer/Db/Function/BackupScheduledSubclients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BackupScheduledSubclients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupScheduledSubclients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BackupScheduledSubclients]
  delete from GXDBVersions where name = 'BackupScheduledSubclients' and type = 5
END
GO

 CREATE FUNCTION BackupScheduledSubclients (
	@i_ClientId	INTEGER
	)
 RETURNS @TblResults TABLE (
	AppId		INTEGER
 )
 AS
 BEGIN
 DECLARE @TblBackupTask TABLE (taskId INT, taskType INT)

 INSERT	INTO @TblBackupTask
 SELECT	DISTINCT T.taskId, T.taskType
 FROM	TM_SubTask ST WITH (NOLOCK)
 	    INNER JOIN TM_Task T WITH (NOLOCK)
 			ON T.taskId = ST.taskId AND T.disabled = 0 AND ST.subTaskType = 2
 	    INNER JOIN TM_SubTaskOptions STO WITH (NOLOCK)
 			ON STO.subTaskId = ST.SubTaskId
 			AND	STO.optionId = 458405394 AND STO.value IN ('1', '2', '3', '6')
 WHERE	T.taskType = 2
 	 OR T.taskType = 4 AND T.taskName NOT IN ('System Created for Content Store', 'System Created for DDB subclients')

 DECLARE @TblBackupTaskAsso TABLE (TaskId INT, AssocType INT, ClientGroupId INT, ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)

 INSERT	INTO @TblBackupTaskAsso
 SELECT	DISTINCT AE.taskId, AE.assocType, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId
 FROM	TM_AssocEntity AE WITH (NOLOCK)
 	    INNER JOIN @TblBackupTask T ON AE.taskId = T.taskId AND AE.exclude = 0
 WHERE	(T.taskType = 2 OR T.taskType = 4 AND AE.assocType NOT IN (2, 28))
 	AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WITH (NOLOCK) WHERE filter_type = 2 AND filter_value = 124)
 UNION
 SELECT	DISTINCT AE.taskId, AE.assocType, AE.clientGroupId, 0, CASE WHEN ISNULL(AF.filter_type, 0) = 1 THEN ISNULL(ATGA.appTypeId, 0) ELSE ISNULL(AF.filter_value, 0) END, 0, 0, 0
 FROM	TM_AssocEntity AE WITH (NOLOCK)
 	    INNER JOIN @TblBackupTask T ON AE.taskId = T.taskId AND T.taskType = 4 AND AE.exclude = 0
 	    LEFT OUTER JOIN TM_AssocFilter AF WITH (NOLOCK) ON AF.taskId = T.taskId
 	    LEFT OUTER JOIN APP_AppTypeGroup ATG WITH (NOLOCK) ON ATG.appTypeGroupId = AF.filter_value AND AF.filter_type = 1
 	    LEFT OUTER JOIN APP_AppTypeGroupAssoc ATGA WITH (NOLOCK) ON ATGA.appGroupId = ATG.appTypeGroupId
 WHERE	AE.assocType IN (2, 28) AND (ISNULL(AF.filter_type, 0) <> 2 OR ISNULL(AF.filter_value, 0) <> 124)

 DECLARE @TblSubclientTask TABLE (taskId INT, appId INT, clientId INT, appTypeId INT, instanceId INT, backupsetId INT)

 INSERT	INTO @TblSubclientTask
 SELECT	T.TaskId, A.id, A.clientId, A.appTypeId, A.instance, A.backupset
 FROM	APP_Application A WITH (NOLOCK), @TblBackupTaskAsso T
 WHERE	T.ClientId IN (A.ClientId, 0) AND (T.ClientId > 0 OR T.AssocType = 2)
 	AND T.AppTypeId IN (A.AppTypeId, 0)
	AND T.InstanceId IN (A.Instance, 0)
	AND T.BackupsetId IN (A.Backupset, 0)
 	AND T.AppId IN (A.id, 0)
  	AND (@i_ClientId = 0 OR A.clientId = @i_ClientId)
 UNION
 SELECT	T.TaskId, A.id, A.clientId, A.appTypeId, A.instance, A.backupset
 FROM	APP_Application A WITH (NOLOCK)
 		INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON A.ClientId = CGA.clientId
		INNER JOIN @TblBackupTaskAsso T ON CGA.ClientGroupId = T.ClientGroupId AND T.ClientId = 0 AND T.ClientGroupId > 0
 WHERE	(T.AppTypeId = 0 OR A.appTypeId = T.AppTypeId)
  	AND (@i_ClientId = 0 OR A.clientId = @i_ClientId)

 DELETE	@TblSubclientTask
 FROM	@TblSubclientTask S
 		INNER JOIN TM_AssocEntity E WITH (NOLOCK) ON S.TaskId = E.taskId AND E.exclude = 1
 		INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON S.ClientId = CGA.clientId AND E.clientGroupId = CGA.clientGroupId
 WHERE	E.clientGroupId > 0 AND E.clientId = 0

 DELETE	@TblSubclientTask
 FROM	@TblSubclientTask S
 		INNER JOIN TM_AssocEntity E WITH (NOLOCK) ON S.TaskId = E.taskId AND E.exclude = 1
 WHERE	E.clientId > 0 AND E.clientId = S.ClientId
 	AND E.apptypeId IN (0, S.appTypeId)
 	AND E.instanceId IN (0, S.instanceId)
 	AND E.backupsetId IN (0, S.backupsetId)
 	AND E.subclientId IN (0, S.appId)

 INSERT	INTO @TblResults
 SELECT appId FROM @TblSubclientTask
 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BackupScheduledSubclients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BackupScheduledSubclients' AND revision = '1.6.50.3')

  insert into GXDBVersions values(5, 'BackupScheduledSubclients',  '1.6.50.3', 'BackupScheduledSubclients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
