

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppPlanIsSnapAddonEnabled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppPlanIsSnapAddonEnabled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppPlanIsSnapAddonEnabled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppPlanIsSnapAddonEnabled]
  delete from GXDBVersions where name = 'AppPlanIsSnapAddonEnabled' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION AppPlanIsSnapAddonEnabled(@i_planId INT, @i_snapScheduleEnabled INT)
RETURNS INT
-- WITH ENCRYPTION
AS BEGIN
		DECLARE @rv INT = 0
DECLARE @planStoragePolicy INT = (SELECT dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage policy',  2/*If this plan does not have it don't retrieve from base*/))
		IF @planStoragePolicy > 0
		BEGIN
			IF @i_snapScheduleEnabled = 1
			BEGIN
				IF EXISTS ( SELECT 1 FROM archGroupCopy AGC WITH(NOLOCK)
								INNER JOIN archGroup AG WITH(NOLOCK) ON AG.id = AGC.archGroupId
								WHERE AG.id = @planStoragePolicy AND AG.defaultSnapCopy = AGC.id AND AGC.isSnapCopy = 1)
				AND EXISTS ( SELECT 1 FROM TM_Subtask ST WITH(NOLOCK)
								INNER JOIN TM_Task T WITH(NOLOCK) ON ST.taskId = T.taskId AND T.disabled = 0 AND T.deleted = 0
								LEFT JOIN TM_AssocEntity AE WITH(NOLOCK) ON AE.taskId = T.taskId
								WHERE AE.policyId = @planStoragePolicy AND ST.operationType = 4028/*SNAP_TO_TAPE*/ AND ST.deleted = 0
AND ST.flags&0x2000000 > 0)
				AND EXISTS( SELECT 1 FROM ArchMaterializeSnapshotProp AMS WITH(NOLOCK) WHERE AMS.archGroupId = @planStoragePolicy AND AMS.enabled = 1)
SET @rv = 1
				ELSE IF EXISTS(SELECT 1 FROM archGroupCopy AGC WITH(NOLOCK)
								INNER JOIN archGroup AG WITH(NOLOCK) ON AG.id = AGC.archGroupId
								WHERE AG.id = @planStoragePolicy AND AG.defaultSnapCopy = AGC.id AND AGC.isSnapCopy = 1)
					AND EXISTS(SELECT 1 FROM TM_Subtask ST WITH(NOLOCK)
								INNER JOIN TM_Task T WITH(NOLOCK) ON ST.taskId = T.taskId AND T.disabled = 1 AND T.deleted = 0
								LEFT JOIN TM_AssocEntity AE WITH(NOLOCK) ON AE.taskId = T.taskId
								WHERE AE.policyId = @planStoragePolicy AND ST.operationType = 4028/*SNAP_TO_TAPE*/ AND ST.deleted = 0
AND ST.flags&0x2000000 > 0)
					AND EXISTS( SELECT 1 FROM ArchMaterializeSnapshotProp AMS WITH(NOLOCK) WHERE AMS.archGroupId = @planStoragePolicy AND AMS.enabled = 0)
SET @rv = 0
				ELSE
SET @rv = 2 /* Status to tell me if i have to create all entities*/
			END
			ELSE
			BEGIN
				IF EXISTS ( SELECT 1 FROM archGroupCopy AGC WITH(NOLOCK)
								INNER JOIN archGroup AG WITH(NOLOCK) ON AG.id = AGC.archGroupId
								WHERE AG.id = @planStoragePolicy AND AG.defaultSnapCopy = AGC.id AND AGC.isSnapCopy = 1)
					SET @rv = 1
				ELSE
					SET @rv = 0
			END
		END
		RETURN @rv
   END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppPlanIsSnapAddonEnabled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppPlanIsSnapAddonEnabled' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'AppPlanIsSnapAddonEnabled',  '1.1.2.3', 'AppPlanIsSnapAddonEnabled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
