

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppPlanGetEntityValue.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppPlanGetEntityValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppPlanGetEntityValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppPlanGetEntityValue]
  delete from GXDBVersions where name = 'AppPlanGetEntityValue' and type = 5
END
GO

 CREATE FUNCTION AppPlanGetEntityValue(@i_planId INT, @i_entityName NVARCHAR(510), @i_mode INT = 0)
 RETURNS VARCHAR(MAX)
 -- WITH ENCRYPTION
 AS BEGIN

    DECLARE @entityPlanId           INT          = @i_planId
    DECLARE @rv                     VARCHAR(MAX) = NULL
    DECLARE @const_modeInheritance  INT          = 1
    DECLARE @const_modeDirectAssoc  INT          = 2

    IF (@i_planId IS NOT NULL) AND (@i_entityName IS NOT NULL) BEGIN

        -- get value directly associated with the plan
        SELECT @rv = COALESCE(@rv + ',', '') + attrVal FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = @i_entityName AND modified = 0

        DECLARE @entityId     INT = NULL
        DECLARE @entityName   NVARCHAR(510)
        DECLARE @level        INT = 0

        -- if value can be inherited then it can be restricted at some level, search for restricting plan and update value if found
        -- search for the entity property tied to
        SELECT @entityId = B.id, @entityName = B.name
        FROM   App_PlanEntity A INNER JOIN App_PlanEntity B ON B.id = A.linkedTo
        WHERE  A.name = @i_entityName

        IF @entityId IS NOT NULL BEGIN
            SET @rv = NULL
        END ELSE BEGIN
            -- search entity itself
            SELECT @entityId = entityId, @entityName = [name] FROM App_PlanEntity WHERE [name] = @i_entityName
        END

        -- SELECT @entityId , @entityName

        -- check mode
        SET @i_mode = IIF(@i_mode IN (@const_modeInheritance, @const_modeDirectAssoc), @i_mode, IIF(EXISTS(SELECT 1 FROM App_planEntity WHERE flag = 1 AND [name] = @entityName), @const_modeInheritance, @const_modeDirectAssoc))

        -- if @i_mode == @const_modeDirectAssoc then value directly associated with the plan should be returned. that value was fetched earlier
        -- if @i_mode == @const_modeInheritance then value could come from the parent plan. search for the plan that supplies the value
        IF @i_mode = @const_modeInheritance AND @entityId IS NOT NULL BEGIN

            DECLARE @hierarchy AS TABLE (planId INT, basePlanId INT, value VARCHAR(MAX), enforced INT, [private] INT, depth INT)
            DECLARE @curPlanId  INT = @i_planId
            DECLARE @basePlanId INT = (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName =  'Base plan')
            DECLARE @depth INT = 0

            WHILE @curPlanId  IS NOT NULL BEGIN

                INSERT INTO @hierarchy VALUES(@curPlanId, @basePlanId, '', '', '', @depth)

                SET @depth += 1
                SET @curPlanId = @basePlanId
                SET @basePlanId = (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @basePlanId AND attrName =  'Base plan')

            END

            UPDATE H SET
                [value]    = (SELECT ISNULL(attrVal, '') FROM APP_PlanProp WHERE componentNameId = planId AND attrName = @entityName  AND modified = 0),
                [enforced] =  dbo.AppPlanIsEntityInTheListV2(@entityId, (SELECT ISNULL(attrVal, '') FROM APP_PlanProp WHERE componentNameId = planId AND attrName =  'Descendants enforced entities' AND modified = 0)),
                [private]  =  dbo.AppPlanIsEntityInTheListV2(@entityId, (SELECT ISNULL(attrVal, '') FROM APP_PlanProp WHERE componentNameId = planId AND attrName =  'Private entities' AND modified = 0))
            FROM @hierarchy H

            --SELECT 'raw', H.* , PP1.attrVal AS enforcedList, PP2.attrVal as privateList FROM  @hierarchy H
            --    INNER JOIN APP_PlanProp PP1 ON PP1.componentNameId = H.planId AND PP1.attrName = 'Descendants enforced entities' AND PP1.modified = 0
            --    INNER JOIN APP_PlanProp PP2 ON PP2.componentNameId = H.planId AND PP2.attrName = 'Private entities' AND PP1.modified = 0

            -- find the lowest level that enforces entity
            SELECT @level = MAX(depth) FROM @hierarchy WHERE enforced != 0

            IF @level IS NOT NULL -- entity is enforced by this plan. find the value plan is enforcing
            BEGIN
                SET @entityPlanId = NULL
                SELECT @entityPlanId = planId FROM @hierarchy WHERE depth = (SELECT MIN(depth) FROM @hierarchy WHERE value IS NOT NULL AND depth >= @level)
                --SELECT 'enforced :', @entityPlanId
            END
            ELSE                  -- entity is not enforced find the one that is not hidden
            BEGIN
                SET @level = NULL
                SET @entityPlanId = NULL

                -- find the highest level that hides entity (makes entity private)
                SET @level = ISNULL((SELECT MIN(depth) FROM @hierarchy WHERE [private] != 0), 0)
                -- find the plan that has value for the entity but which inheritance level is less than highest level that hides entity
                SELECT @entityPlanId = planId FROM @hierarchy WHERE depth = (SELECT MIN(depth) FROM @hierarchy WHERE (value IS NOT NULL) AND (depth < @level OR @level = 0))

                --SELECT 'private :', @entityPlanId
            END

            SET @rv = NULL
            -- get entity value for the plan that supplies the value
            SET @rv = (SELECT COALESCE(@rv + ',', '') + PP.attrVal
                        FROM APP_PlanProp PP
                        WHERE PP.componentNameId = @entityPlanId AND PP.attrName = @i_entityName AND PP.modified = 0)

        END

    END
    RETURN @rv
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppPlanGetEntityValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppPlanGetEntityValue' AND revision = '1.1.2.9')

  insert into GXDBVersions values(5, 'AppPlanGetEntityValue',  '1.1.2.9', 'AppPlanGetEntityValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
