

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppPlanGetBasePlanV2.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppPlanGetBasePlanV2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppPlanGetBasePlanV2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppPlanGetBasePlanV2]
  delete from GXDBVersions where name = 'AppPlanGetBasePlanV2' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION AppPlanGetBasePlanV2(@i_planId INT, @i_mode INT = 0)
RETURNS INT
AS
BEGIN
	DECLARE @const_modeInheritance  INT          = 1
	DECLARE @const_modeDirectAssoc  INT          = 2
	DECLARE @planId					INT			 = @i_planId
	DECLARE @basePlanId             INT          = NULL
	SET @i_mode = IIF(@i_mode IN (@const_modeInheritance, @const_modeDirectAssoc), @i_mode, @const_modeInheritance)
	IF @i_mode = @const_modeDirectAssoc
		-- just get immediate parent.
		-- If there is no base plan then info for @i_planId will be returned and @rv value will be set to
SET @basePlanId = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Base plan'),  @i_planId)
	ELSE
	BEGIN
		-- iterate through the plans hierarchy
		-- it could be done using while loop and using CTE and it seems that simple loop in this case is more effective
		--
		-- |               |      % relative to the batch        |
		-- |hierarchy dept +-------------------------------------+
		-- |               | cte implementation | loop (combined)|
		-- +---------------+--------------------+----------------+
		-- |             1 |        37          |       6        |
		-- |             2 |        31          |       12       |
		-- |             3 |        26          |       16       |
		-- |             4 |        22          |       19       |
		--
		-- deepest hierarchy level expected is 3.
		--
		-- If there is no base plan then info for @i_planId will be returned and @rv value will be set to
		WHILE (@i_planId IS NOT NULL)
		BEGIN
			SET @basePlanId = @i_planId
SET @i_planId = (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Base plan')
		END
	END
	IF @basePlanId=@planId
	BEGIN
		SET @basePlanId = 0
	END
	RETURN @basePlanId
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppPlanGetBasePlanV2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppPlanGetBasePlanV2' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'AppPlanGetBasePlanV2',  '1.1.2.1', 'AppPlanGetBasePlanV2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
