

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppPlanGetAssociatedValuesV2.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: AppPlanGetAssociatedValuesV2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppPlanGetAssociatedValuesV2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppPlanGetAssociatedValuesV2]
  delete from GXDBVersions where name = 'AppPlanGetAssociatedValuesV2' and type = 5
END
GO

 CREATE FUNCTION AppPlanGetAssociatedValuesV2(@i_planId INT, @i_mode INT = 0)
 RETURNS @rv TABLE(depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), planEntityId INT, [Status] INT, PRIMARY KEY(attrName))
 -- WITH ENCRYPTION
 AS BEGIN

    DECLARE @const_modePrivateCutoff    INT = 1
    DECLARE @const_modePrivateFallThru  INT = 2
    DECLARE @const_modeDirectAssoc      INT = 3
    IF @i_planId IS NOT NULL BEGIN
        SET @i_mode = IIF(@i_mode = 0, @const_modePrivateCutoff, @const_modeDirectAssoc)
    END
    DECLARE @entityNameMap AS TABLE(entityId INT, propertyName VARCHAR(512) PRIMARY KEY, propertyType INT)
    INSERT INTO @entityNameMap SELECT entityId,name,type  FROM App_PlanEntity
    DECLARE @planProps AS TABLE(depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(4096), [Private] VARCHAR(MAX), [Enforced] VARCHAR(MAX), [entityType] INT)
    DECLARE @depth  INT = 0

     WHILE (@i_planId IS NOT NULL) AND (((@i_mode = @const_modeDirectAssoc) AND (@depth = 0)) OR (@i_mode != @const_modeDirectAssoc))  BEGIN

         INSERT INTO @planProps
             SELECT  @depth, A1.componentNameId, A1.attrName, A1.attrType, A1.attrVal, A2.attrVal, A3.attrVal, ISNULL(EN.entityId, 0)
             FROM    App_PlanProp A1 WITH(NOLOCK) LEFT JOIN App_PlanProp     A2 WITH(NOLOCK) ON A1.componentNameId = A2.componentNameId AND A2.attrName = 'Private entities'
                                                     LEFT JOIN App_PlanProp     A3 WITH(NOLOCK) ON A1.componentNameId = A3.componentNameId AND A3.attrName = 'Descendants enforced entities'
                                                     LEFT JOIN App_PlanEntity   EN ON A1.attrName = EN.name

             WHERE   -- not deleted entries for the current iteration's plan
                     A1.componentNameId = @i_planId AND A1.modified = 0
                     -- entries that can be inherited
                     AND (@depth = 0 OR A1.attrName IN ('Alert', 'Schedule policy', 'Storage policy', 'Log schedule policy', 'Log storage policy', 'Subclient policy', 'Subclient policy 2', 'Subclient policy 3', 'Subclient policy 4', 'Replication schedule policy', 'Number of synth full versions', 'Subclient retention period', 'Exchange mailbox archiving policy', 'Exchange mailbox retention policy', 'Exchange mailbox cleanup policy',                                                  'Exchange mailbox journal policy'))

         -- next iteration
         SET @depth += 1
         SET @i_planId = (SELECT CAST(attrVal AS int) FROM App_PlanProp WHERE @i_mode = 1 AND componentNameId = @i_planId AND attrName = 'Base plan')

     END

     IF @i_mode = @const_modePrivateCutoff BEGIN

         DECLARE @allPrivateEntities VARCHAR(MAX) = NULL
         SELECT  @allPrivateEntities = COALESCE(@allPrivateEntities + ',', '') + [Private] FROM @planProps

         DELETE  FROM @planProps
         WHERE (depth != 0) AND (dbo.AppPlanIsEntityInTheListV2(entityType, @allPrivateEntities) = 1)

     END ELSE BEGIN

         DELETE  FROM PP
         FROM    @planProps PP
         WHERE   ((depth != 0) AND (dbo.AppPlanIsEntityInTheListV2(PP.entityType, PP.[Private]) = 1))

     END
     -- remove enforced entities.
     WHILE @depth > 0 BEGIN

         DECLARE @enforcedEntities VARCHAR(MAX) = (SELECT TOP 1 Enforced FROM @planProps WHERE depth = @depth)

         DELETE  FROM P1
         FROM    @planProps P1
         WHERE       P1.depth < @depth
                 AND P1.attrName IN (SELECT E2.name FROM dbo.SplitIDString(ISNULL(@enforcedEntities, '0')) E1 INNER JOIN APP_PlanEntity E2 ON E1._ID = E2.entityId)

         -- next iteration
         SET @depth -= 1
     END
     -- remove duplicated entites from the base plans
     DELETE FROM P1
     FROM @planProps P1 WHERE EXISTS (SELECT 1 FROM @planProps P2 WHERE P1.attrName = P2.attrName AND P1.depth > P2.depth)

     -- insert values into return table calculating entites status
     INSERT INTO @rv
         SELECT DISTINCT  depth, componentNameId, attrName, attrType, SUBSTRING((SELECT  ',' + PP2.attrVal AS [text()]
                                                                                 FROM    @planProps PP2
                                                                                 WHERE   PP2.attrName = PP1.attrName
                                                                                 FOR XML PATH ('')), 2, 4096) AS attrVal,
                                                                                 -- status calculation
                                                                                 entityType,
                                                                                 IIF(dbo.AppPlanIsEntityInTheListV2(PP1.entityType, PP1.[Private]) = 1, 1,
                                                                                 IIF(dbo.AppPlanIsEntityInTheListV2(PP1.entityType, PP1.Enforced)  = 1, 2, 0))
         FROM  @planProps PP1

     RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppPlanGetAssociatedValuesV2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppPlanGetAssociatedValuesV2' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'AppPlanGetAssociatedValuesV2',  '1.1.2.7', 'AppPlanGetAssociatedValuesV2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
