

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppPlanCanDisableAddon.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppPlanCanDisableAddon'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppPlanCanDisableAddon]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppPlanCanDisableAddon]
  delete from GXDBVersions where name = 'AppPlanCanDisableAddon' and type = 5
END
GO

    SET QUOTED_IDENTIFIER ON
    GO
    CREATE FUNCTION AppPlanCanDisableAddon(@i_planId INT, @i_addonType INT)
    RETURNS INT
    BEGIN
IF @i_addonType = 1
		BEGIN
			--If there is atleast one subclient with intellisnap enabled and associated to this plan we can't disable addon so return 0
			IF EXISTS(SELECT 1 FROM APP_SubClientProp ASCP1 WITH(NOLOCK)
						INNER JOIN APP_SubClientProp ASCP2 WITH(NOLOCK)
                        ON ASCP1.componentNameId = ASCP2.componentNameId
						INNER JOIN APP_Application APP WITH(NOLOCK)
ON APP.id = ASCP1.componentNameId AND APP.subclientStatus & 0x00004  <> 0x00004
WHERE ASCP1.attrName = 'Associated Plan' AND ASCP1.attrVal = CAST(@i_planId AS NVARCHAR(32)) AND ASCP1.modified = 0
AND ASCP2.attrName = 'Enable Snap Backups' AND ASCP2.attrVal = '1' AND ASCP2.modified = 0)
				RETURN 0
			ELSE
				RETURN 1
		END
		RETURN 1
    END
    GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppPlanCanDisableAddon]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppPlanCanDisableAddon' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'AppPlanCanDisableAddon',  '1.1.2.2', 'AppPlanCanDisableAddon', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
