

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppGetWebSvcUrlForIndexServer.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppGetWebSvcUrlForIndexServer'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGetWebSvcUrlForIndexServer]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppGetWebSvcUrlForIndexServer]
  delete from GXDBVersions where name = 'AppGetWebSvcUrlForIndexServer' and type = 5
END
GO

	CREATE FUNCTION AppGetWebSvcUrlForIndexServer(@i_indexServerClientId INT, @i_webserverClientId INT, @i_packageId INT)
		RETURNS @WebSvcUrl TABLE ( clientId INT, webSvcUrl NVARCHAR(512))
		AS
		BEGIN
		DECLARE @webServiceUrl	NVARCHAR(1024) =N''
		DECLARE @indexServerHostname	NVARCHAR(256) =N''
		DECLARE @indexServerPortNum		VARCHAR(10) =''
		DECLARE @indexServerWebServerAlias	NVARCHAR(64) =N''
		DECLARE @webClientId	INT =0
		DECLARE @packageId	INT =0
		DECLARE @indexServerPortAttrName		VARCHAR(32) ='IndexStore Web Site Port'
		DECLARE @indexServerWebServerAliasName		VARCHAR(32) = 'IndexStore Search Web Alias'
		--get web client id for index gateway or webserver
		SELECT TOP 1 @webClientId = ISNULL (S.clientId,0), @packageId = P.simPackageId
			FROM DM2Cloud DC (NOLOCK)
			JOIN DM2SearchServerCoreInfo S (NOLOCK) ON DC.CloudId = S.CloudId
			JOIN SIMInstalledPackages P (NOLOCK) ON S.clientId = P.clientId
			WHERE ( (@i_webserverClientId=0 AND  DC.pseudoClientId = @i_indexServerClientId) OR (S.clientId=@i_webserverClientId) )
					AND (P.simPackageId = @i_packageId
						OR (@i_packageId = 0 AND P.simPackageId IN (252,1174, 263, 1156)))
			ORDER BY P.simPackageId ASC
		--get url for webserver only
		IF (@packageId IN (252,1174))
		BEGIN
			SET @indexServerPortAttrName	    ='DM2WebService Web Site Port'
			SET @indexServerWebServerAliasName	='DM2WebService Search Web Alias'
		END
		--get web service url for webClientId
		IF @webClientId > 0
		BEGIN
			SET @indexServerHostname = ISNULL((SELECT net_hostname FROM APP_Client (NOLOCK) WHERE id = @webClientId), N'')
			SET @indexServerPortNum = ISNULL((SELECT attrVal FROM APP_ClientProp (NOLOCK) WHERE componentNameid = @webClientId AND attrName = @indexServerPortAttrName), N'')
			SET @indexServerWebServerAlias = ISNULL((SELECT attrVal FROM APP_ClientProp (NOLOCK) WHERE componentNameid = @webClientId AND attrName = @indexServerWebServerAliasName), N'')
			IF (@indexServerHostname<>'' and @indexServerPortNum<>'' and @indexServerWebServerAlias<>'')
			BEGIN
				SET @webServiceUrl	 = 'http://' + @indexServerHostname + ':' + @indexServerPortNum + '/' + @indexServerWebServerAlias + '/'
			END
			IF (@packageId NOT IN (252,1174) and @webServiceUrl <> '')
			BEGIN
				SET @webServiceUrl	 = @webServiceUrl + 'api/'
			END
			INSERT INTO @WebSvcUrl (clientId, webSvcUrl)
			VALUES (@webClientId, @webServiceUrl)
		END
		RETURN
		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppGetWebSvcUrlForIndexServer]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppGetWebSvcUrlForIndexServer' AND revision = '1.1.2.6')

  insert into GXDBVersions values(5, 'AppGetWebSvcUrlForIndexServer',  '1.1.2.6', 'AppGetWebSvcUrlForIndexServer', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
