

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppGetUserGroupRoleType.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: AppGetUserGroupRoleType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGetUserGroupRoleType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppGetUserGroupRoleType]
  delete from GXDBVersions where name = 'AppGetUserGroupRoleType' and type = 5
END
GO

CREATE FUNCTION AppGetUserGroupRoleType(@groupId integer)
RETURNS INT
AS
BEGIN
	DECLARE @roleType Int=-1
	DECLARE @flags int = 0
	DECLARE @name varchar(255)
	DECLARE @umdsProviderId int =0
	SELECT @flags=groupFlags, @name = name, @umdsProviderId=umdsProviderId FROM UMGroups WITH (NOLOCK) WHERE id = @groupId
	--Verify if thers is owner company
	DECLARE @ownerProviderId int = 0
	SELECT @ownerProviderId = ownerCompany FROM UMDSProviders WITH (NOLOCK) WHERE ID = @umdsProviderId
	IF(@ownerProviderId > 0)
	BEGIN
		SET @umdsProviderId=@ownerProviderId
	END
	IF (@name is not null)
	BEGIN
       DECLARE @isRestrictedViewEnabled INT = ISNULL(CAST( (SELECT TOP (1) value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Restricted View Enabled' AND modified = 0) AS INT), 0)
        IF @isRestrictedViewEnabled <> 0
		BEGIN
			IF (@name = N'CV_Restricted_Visibility')
			BEGIN
SET @roleType =  4
				GOTO EXIT_OUT
			END
		END
IF (@flags&0x10000 > 0)
		BEGIN
SET @roleType =  1
			GOTO EXIT_OUT
		END
IF EXISTS(SELECT 1 FROM UMDSProviders WITH (NOLOCK) WHERE serviceType = 5 AND id = @umdsProviderId)
		BEGIN
SET @roleType = 2
			GOTO EXIT_OUT
		END
		IF EXISTS(SELECT Sec.roleID
		   FROM UMSecurityAssociations Sec WITH (NOLOCK)
				LEFT JOIN UMRolesWithPermissionsExpanded RPE WITH (NOLOCK)
					ON Sec.roleID = RPE.roleId AND RPE.permissionId = 1
			WHERE
				Sec.isUser = 0 AND Sec.userOrGroupId = @groupId
				AND Sec.entityType1 = 1 AND Sec.entityID1 = 2
				AND (Sec.permissionId = 1 OR RPE.roleId is not null))
		BEGIN
SET @roleType =  0
			GOTO EXIT_OUT
		END
SET @roleType = 3 --default role
	END
	EXIT_OUT:
	RETURN @roleType
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppGetUserGroupRoleType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppGetUserGroupRoleType' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'AppGetUserGroupRoleType',  '1.1.2.3', 'AppGetUserGroupRoleType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
