

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppGetPlanForUser.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: AppGetPlanForUser'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGetPlanForUser]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppGetPlanForUser]
  delete from GXDBVersions where name = 'AppGetPlanForUser' and type = 5
END
GO

CREATE FUNCTION AppGetPlanForUser (@userId INT)
RETURNS INTEGER
AS
BEGIN
DECLARE @constAttrName_AssociatedPlan NVARCHAR(32) = 'Associated Plan'
declare @planId int = 0
-- if user is explicitly invited to plan, then use that planId.
select @planId = CAST(attrVal AS INT)
from UMUsersProp WITH (READUNCOMMITTED)
where attrname = @constAttrName_AssociatedPlan
and componentNameId = @userId
and modified = 0
if (@planId is not NULL and @planId>0)
begin
	return @planId
end
-- if user is invited to plan via simpana group or AD group, then use that planId.
select @planId = CAST(attrVal AS INT)
from UMUserGroup WITH (READUNCOMMITTED)
inner join UMGroupsProp on UMUserGroup.userId=@userId and UMGroupsProp.componentNameId = UMUserGroup.groupId
AND attrName = @constAttrName_AssociatedPlan AND modified = 0
return @planId
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppGetPlanForUser]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppGetPlanForUser' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'AppGetPlanForUser',  '1.1.2.3', 'AppGetPlanForUser', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
