

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppGetOpWindowIntervals.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppGetOpWindowIntervals'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGetOpWindowIntervals]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppGetOpWindowIntervals]
  delete from GXDBVersions where name = 'AppGetOpWindowIntervals' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION AppGetOpWindowIntervals(@i_opWindowId INT, @i_startTime INT, @i_endTime INT)
RETURNS @opIntervals TABLE(startTime INT,endTime INT)
AS
BEGIN
	--week of the month flags
    DECLARE @WEEK_OF_THE_MONTH_FIRST    INT = 0x01
    DECLARE @WEEK_OF_THE_MONTH_SECOND   INT = 0x02
    DECLARE @WEEK_OF_THE_MONTH_THIRD    INT = 0x04
    DECLARE @WEEK_OF_THE_MONTH_FOURTH   INT = 0x08
    DECLARE @WEEK_OF_THE_MONTH_LAST     INT = 0x10
    DECLARE @WEEK_OF_THE_MONTH_ALL      INT = 0x20
	DECLARE @daysCount INT = 0
	DECLARE @startTimeO INT
	DECLARE @endTimeO INT
	DECLARE @startDateO INT
	DECLARE @endDateO INT
	DECLARE @daysOfWeekO INT
	DECLARE @weekOfMonthO INT
	DECLARE @clientId INT = 2
	DECLARE @appType INT = 0
	DECLARE @n INT = 1
	DECLARE @totalRules INT = 1
	DECLARE @secondsInHour INT = 60*60
	DECLARE @secondsInDay INT = 60*60*24
	DECLARE @currentDate INT = DATEDIFF(SECOND,'19700101',getutcdate())
	DECLARE @i_startTimeDay INT = (@i_startTime / @secondsInDay) * @secondsInDay
	DECLARE @i_endTimeDay INT = (@i_endTime / @secondsInDay) * @secondsInDay
	DECLARE @allHours TABLE (startTime INT, endTime INT, weekOfMonth INT, day INT, isAffected INT)
	DECLARE @opWindowRules TABLE (id INT IDENTITY(1,1), startTime INT, endTime INT, startDate INT, endDate INT, daysOfWeek INT, weekOfMonth INT)
	INSERT INTO @opWindowRules
	SELECT startTime, endTime, startDate,endDate, daysOfWeek, weekOfTheMonth FROM APP_OpWindowRule WITH (NOLOCK) WHERE id = @i_opWindowId
	SELECT @totalRules = COUNT(*), @clientId = MAX(clientId), @appType = MAX(appTypeId) FROM APP_OpWindowRule WHERE id = @i_opWindowId
	IF @appType = 1000 OR @clientId = 0--When check is required at CS level alone
		SET @clientId =  2
	WHILE @n <= @totalRules
	BEGIN
		SELECT @startTimeO = startTime, @endTimeO = endTime, @startDateO = startDate, @endDateO = endDate, @daysOfWeekO = daysOfWeek, @weekOfMonthO = weekOfMonth FROM @opWindowRules WHERE id  =  @n
		 DECLARE @ClientTime DATETIME
		 DECLARE @year INT = 0
		 DECLARE @month INT = 0
		 DECLARE @weekday INT = 0
		 DECLARE @day INT = 0
		 DECLARE @hour INT = 0
		 DECLARE @minute INT = 0
		 DECLARE @second INT = 0
		 DECLARE @localMidNightEpoch INT = 0
		 DECLARE @weekOfmonth  INT = 0
		 DECLARE @isLastWeek INT = 0
		 DECLARE @ClientTimeE DATETIME
		 DECLARE @yearE INT = 0
		 DECLARE @monthE INT = 0
		 DECLARE @weekdayE INT = 0
		 DECLARE @dayE INT = 0
		 DECLARE @hourE INT = 0
		 DECLARE @minuteE INT = 0
		 DECLARE @secondE INT = 0
		 DECLARE @localMidNightEpochE INT = 0
		 DECLARE @evalDay INT = 0
		 SELECT @ClientTimeE = clientTime, @yearE = year, @monthE = month, @weekdayE = weekday, @dayE = day, @hourE = hour, @minuteE = minute, @secondE = seconds , @localMidNightEpochE = localMidNightEpoch
            FROM dbo.GetUTCToClientLocalTimeInParts(@i_endTimeDay,@clientID)
		 SET @evalDay = @i_startTimeDay
		 WHILE @evalDay <= @i_endTimeDay + @secondsInDay
		 BEGIN
			SELECT @ClientTime = clientTime, @year = year, @month = month, @weekday = weekday, @day = day, @hour = hour, @minute = minute, @second = seconds , @localMidNightEpoch = localMidNightEpoch
            FROM dbo.GetUTCToClientLocalTimeInParts(@evalDay,@clientID)
			SET @weekOfmonth = DATEDIFF(WEEK, DATEADD(MONTH, DATEDIFF(MONTH, 0, @ClientTime), 0), @ClientTime) +1
			SET @isLastWeek = (SELECT (CASE WHEN numberOfWeeks = @weekOfmonth THEN 1 ELSE 0 END)
								FROM APP_YearMonthNumberOfWeeks
								WHERE yearNo = @year
								AND monthNo = @month)
			SET @weekOfmonth = POWER(2, @weekOfMonth - 1)
			SET @weekday = POWER(2, @weekday - 1)
			IF (@startDateO <= @localMidNightEpoch OR @startDateO = 0) AND(@endDateO >= @localMidNightEpoch OR @endDateO = 0) AND @weekday & @daysOfWeekO > 0 AND
			(((@weekOfMonthO & @weekOfmonth) <> 0) OR (@weekOfMonthO = @WEEK_OF_THE_MONTH_LAST AND @isLastWeek = 1) OR (@weekOfMonthO = @WEEK_OF_THE_MONTH_ALL ))
			BEGIN
				DECLARE @OpStart INT = @localMidNightEpoch + @startTimeO
				DECLARE @OpEnd INT = @localMidNightEpoch + @endTimeO
				IF (@OpStart BETWEEN @i_startTime AND @i_endTime) OR (@OpEnd BETWEEN @i_startTime AND @i_endTime) OR (@OpStart < @i_startTime AND @OpEnd > @i_endTime)
					INSERT INTO @opIntervals
					SELECT DATEDIFF(SECOND,'19700101',dbo.ClientLocalToUTCTime(DATEADD(SECOND, @evalDay + @startTimeO, '19700101'),@clientId)),DATEDIFF(SECOND, '19700101', dbo.ClientLocalToUTCTime(DATEADD(SECOND, @evalDay + @endTimeO, '19700101'),@clientId))
			END
			 SET @evalDay = @evalDay + @secondsInDay
		 END;
		SET @n = @n + 1
	END;
	-- this is required for forecasting runtime
	IF ISNULL((SELECT MAX(endTime) FROM @opIntervals),0) < @i_endTime
		INSERT INTO @opIntervals
			SELECT @i_endTime,@i_endTime
	RETURN;
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppGetOpWindowIntervals]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppGetOpWindowIntervals' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'AppGetOpWindowIntervals',  '1.1.2.3', 'AppGetOpWindowIntervals', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
