

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppGetExpiryInfoForSP.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppGetExpiryInfoForSP'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGetExpiryInfoForSP]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppGetExpiryInfoForSP]
  delete from GXDBVersions where name = 'AppGetExpiryInfoForSP' and type = 5
END
GO

 CREATE FUNCTION AppGetExpiryInfoForSP(@currentServicePackNumber INT, @releaseId INT)
 RETURNS INT
    AS BEGIN
        DECLARE @servicePackExpiredDateInUnixTimeStamp INT = -1
        DECLARE @seedTime VARCHAR(50) = '15-Dec-2016' -- Taking seed time as SP6 release date
        DECLARE @unixtimeStampStartTime VARCHAR(50) = '1970-01-01 00:00:00'
        DECLARE @spExpiredInMonth INT = 12


        IF @currentServicePackNumber <= 6
            BEGIN
                RETURN @servicePackExpiredDateInUnixTimeStamp
            END

        IF @releaseId >= 16 AND @currentServicePackNumber >= 16 AND @currentServicePackNumber%4 = 0
            BEGIN
                SET @spExpiredInMonth = 5*12 -- For LTS sp :: It will expiry in next 5 years.
            END

        DECLARE @months INT = 3*(@currentServicePackNumber-6)
        DECLARE @spReleaseDate VARCHAR(50) = DATEADD (month, @months, @seedTime)
        DECLARE @spExpiredDate VARCHAR(50) = DATEADD (month, @spExpiredInMonth, @spReleaseDate)
        SET @servicePackExpiredDateInUnixTimeStamp = DATEDIFF(s, @unixtimeStampStartTime, @spExpiredDate)
        RETURN @servicePackExpiredDateInUnixTimeStamp
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppGetExpiryInfoForSP]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppGetExpiryInfoForSP' AND revision = '')

  insert into GXDBVersions values(5, 'AppGetExpiryInfoForSP',  '', 'AppGetExpiryInfoForSP', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
