

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppGetExchangeCollectionName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppGetExchangeCollectionName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGetExchangeCollectionName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppGetExchangeCollectionName]
  delete from GXDBVersions where name = 'AppGetExchangeCollectionName' and type = 5
END
GO

    CREATE FUNCTION AppGetExchangeCollectionName(@i_cloudId INT ,  	@i_subSourceType VARCHAR(24) , 	@i_backupsetGuid VARCHAR(512), @i_dataSourceId INT )
    RETURNS VARCHAR(128)
    AS
    BEGIN
    	DECLARE @o_collectionName VARCHAR(128) = ''
		DECLARE @backupsetPropName VARCHAR(256) = 'Indexing datasource id'
		IF @i_subSourceType = 'metainfo'
			SET @backupsetPropName = 'Indexing metainfo datasource id'
		IF @i_dataSourceId >= 0
		BEGIN
			IF @i_dataSourceId = 0
				SET @i_dataSourceId = CAST(ISNULL((dbo.GetBackupsetProp((SELECT id FROM APP_BackupSetName(NOLOCK) WHERE guid = @i_backupsetGuid), @backupsetPropName)) ,'-1') AS INT)
			IF @i_dataSourceId > 0
					SET @o_collectionName = dbo.SEGetCollectionName(@i_dataSourceId)
			ELSE
			BEGIN
				--pivot by 3 property for the matching datasource belonging to input cloudId, then match the value
				--
				;WITH CTE AS (
					SELECT DataSourceId AS DataSourceId, ActualCoreName , [sourcetype] 'SourceType' , [subsourcetype] 'SubSourceType', [backupsetguid] 'BackupsetGuid'
					FROM
					(   SELECT DSP.DataSourceId, CI.ActualCoreName, DSP.PropertyValue 'Value', p.PropertyName
						FROM SEDataSource DS WITH (NOLOCK)
							INNER JOIN  SECollectionInfo CI WITH (NOLOCK)  ON DS.CoreId = CI.CoreId AND CI.CloudID = @i_cloudId
							INNER JOIN  SEDataSourceProperty DSP  WITH (NOLOCK)  ON DS.DataSourceId = DSP.DataSourceId
							INNER JOIN  SEProperty P ON DSP.PropertyId = P.PropertyId
						 WHERE P.PropertyName IN ('sourcetype', 'subsourcetype','backupsetguid')
					) AS SourceTable
					PIVOT
					( MIN(Value) FOR PropertyName IN ([sourcetype], [subsourcetype], [backupsetguid]) ) AS PivotTable
				)
				SELECT TOP 1 @o_collectionName = CTE.ActualCoreName from CTE where cte.BackupsetGuid = @i_backupsetGuid AND cte.SubSourceType = @i_subSourceType AND Cte.SourceType = 'exchange'
			END
		END
		RETURN @o_collectionName
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppGetExchangeCollectionName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppGetExchangeCollectionName' AND revision = '1.1.4.6')

  insert into GXDBVersions values(5, 'AppGetExchangeCollectionName',  '1.1.4.6', 'AppGetExchangeCollectionName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
