

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppGetEdgeWebServerUrlForWebServerId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppGetEdgeWebServerUrlForWebServerId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGetEdgeWebServerUrlForWebServerId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppGetEdgeWebServerUrlForWebServerId]
  delete from GXDBVersions where name = 'AppGetEdgeWebServerUrlForWebServerId' and type = 5
END
GO

	CREATE FUNCTION AppGetEdgeWebServerUrlForWebServerId(@i_WebServerId int)
		RETURNS NVARCHAR(MAX)
		AS
		BEGIN
		DECLARE @WebServerUrl nvarchar(max) = ''
		DECLARE @hostname NVARCHAR(MAX) = ''
		DECLARE @portNum NVARCHAR(MAX) = ''
		DECLARE @webServerAlias NVARCHAR(MAX) = ''
		SELECT @hostname = ISNULL((SELECT net_hostname
		FROM APP_Client WITH(NOLOCK)
		WHERE id = @i_WebServerId), '')
		SET @portNum = ISNULL((SELECT attrVal
		FROM APP_ClientProp WITH (NOLOCK)
		WHERE componentNameId = @i_WebServerId
		AND attrName = 'DM2WebService Web Site Port'
		AND modified = 0), '')
		SET @webServerAlias = ISNULL((SELECT attrVal
				  FROM APP_ClientProp  WITH (NOLOCK)
				  WHERE componentNameId = @i_WebServerId
				  AND attrName = 'DM2WebService Search Web Alias'
		          AND modified = 0), '')
		IF(LEN(@hostname) > 0 AND LEN(@portNum) > 0 AND LEN(@webServerAlias) > 0)
			SET @WebServerUrl = 'http://' + @hostname + ':' + @portNum + '/' + @webServerAlias + '/'
		RETURN 	@WebServerUrl
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppGetEdgeWebServerUrlForWebServerId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppGetEdgeWebServerUrlForWebServerId' AND revision = '1.2')

  insert into GXDBVersions values(5, 'AppGetEdgeWebServerUrlForWebServerId',  '1.2', 'AppGetEdgeWebServerUrlForWebServerId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
