

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppFetchWebServiceURL.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppFetchWebServiceURL'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppFetchWebServiceURL]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppFetchWebServiceURL]
  delete from GXDBVersions where name = 'AppFetchWebServiceURL' and type = 5
END
GO

CREATE FUNCTION AppFetchWebServiceURL(@webServerClientId integer, @includeAlias tinyint, @includeEndPoint tinyint)
RETURNS nvarchar(max)
AS
BEGIN
	DECLARE @webServerHttpSecure			NVARCHAR(MAX) = ''
	DECLARE @WebServiceSecurePortSetting	VARCHAR(20) = 'WebServerHttpSecure'
	DECLARE @WebServiceInternalNameSetting	VARCHAR(30) = ''
	DECLARE @portNum						NVARCHAR(MAX) = ''
	DECLARE @finalURL						NVARCHAR(MAX) = ''
	DECLARE @protocol						VARCHAR(10) = 'http'
	IF ISNULL(@includeEndPoint, 1) = 1
	BEGIN
		-- it doesn't make sense to not include alias name when including end point
		-- so force this flag for such scenario..
		SET @includeAlias = 1
	END
	SET @WebServiceInternalNameSetting = ISNULL(dbo.AppGetAdditionalSettingForClient(@webServerClientId, 'sIISInternalHostname', 'Session'), '')
	    -- Check setting at client level
    SET @portNum = ISNULL(dbo.AppGetAdditionalSettingForClient(@webServerClientId, @WebServiceSecurePortSetting, 'DM2WebSearchServer'), '')
	--if not present at client level, check it at comm-cell level
    IF LEN(@portNum) = 0
        SET @portNum = ISNULL((SELECT value FROM GXGlobalParam WITH(NOLOCK) WHERE name = @WebServiceSecurePortSetting AND modified = 0), '')
	-- if https not enabled, then get the port for http
	IF LEN(@portNum) = 0
	BEGIN
		SET @portNum = ISNULL((SELECT attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @webServerClientId AND attrName = 'DM2WebService Web Site Port' AND modified = 0), '')
	END
	ELSE
	BEGIN
		SET @protocol = 'https'
	END
	IF LEN(@portNum) = 0 OR @portNum = '0'
	BEGIN
		SET @portNum = '81'
	END
	SET @protocol = @protocol + '://'
    SELECT @finalURL = @protocol + (CASE WHEN @WebServiceInternalNameSetting <> '' THEN @WebServiceInternalNameSetting ELSE A.net_hostname END) + ':' + @portNum
	FROM APP_Client A WITH(NOLOCK)
	WHERE ID = @webserverclientid
	IF ISNULL(@includeAlias, 0) = 1
	BEGIN
		DECLARE @alias varchar(64)
		SET @alias = ISNULL((SELECT attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @webServerClientId AND attrName = 'DM2WebService Search Web Alias' AND modified = 0), '')
		SELECT @finalURL = @finalURL + '/' + (CASE WHEN @alias = '' THEN 'SearchSvc' ELSE @alias END)
	END
	IF ISNULL(@includeEndPoint, 0) = 1
	BEGIN
		SELECT @finalURL = @finalURL + '/CVWebService.svc'
	END
	RETURN @finalURL
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppFetchWebServiceURL]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppFetchWebServiceURL' AND revision = '1.1.4.3')

  insert into GXDBVersions values(5, 'AppFetchWebServiceURL',  '1.1.4.3', 'AppFetchWebServiceURL', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
