

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppCheckVMPolicySecurityPermissions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppCheckVMPolicySecurityPermissions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppCheckVMPolicySecurityPermissions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppCheckVMPolicySecurityPermissions]
  delete from GXDBVersions where name = 'AppCheckVMPolicySecurityPermissions' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION AppCheckVMPolicySecurityPermissions ( @userId integer, @policyId integer, @flags integer)
	RETURNS integer
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result integer = 0
		IF (@flags = 0)
		BEGIN
			IF EXISTS (SELECT * FROM app_vmallocationpolicyprop WHERE @policyId=componentNameId AND @userId=CAST(attrVal as INT) AND (attrName='user'))
				SET @result = 1
			IF (@result = 0)
				IF EXISTS (SELECT * FROM umusergroup AS UG INNER JOIN app_vmallocationpolicyprop AS VM_APP ON CAST(VM_APP.attrVal as INT)=UG.groupId
									 WHERE (@policyId=VM_APP.componentNameId) AND (UG.userId=@userId) AND (VM_APP.attrName='usergroup'))
												SET @result	= 1
			IF (@result = 0)
				IF EXISTS (SELECT * FROM umdsusergroup AS UG INNER JOIN app_vmallocationpolicyprop AS VM_APP ON CAST(VM_APP.attrVal as INT)=UG.groupId
									 WHERE (@policyId=VM_APP.componentNameId) AND (UG.userId=@userId) AND (VM_APP.attrName='extusergroup'))
												SET @result	= 1
			IF (@result = 0)
				IF EXISTS (SELECT * FROM UMDSUserGroup AS UG INNER JOIN UMDSGroupMaps AS UDSM ON  UDSM.umDSgroupId = UG.groupId JOIN app_vmallocationpolicyprop AS VM_APP ON CAST(VM_APP.attrVal as INT)=UDSM.umgroupId
								 WHERE (@policyId=VM_APP.componentNameId) AND (UG.userId=@userId) AND (VM_APP.attrName='usergroup'))
												SET @result =1
			END
		ELSE
		BEGIN
			SELECT	@result = dbo.IsClientVisible(@userId, A.clientId, 0, 0, 0, 0)
			FROM	App_VMAllocationPolicy P
					INNER JOIN App_VMDataCenterMap M
						ON P.vDataCenterId = M.vDataCenterId
					INNER JOIN APP_Application A
						ON M.instanceId = A.instance
			WHERE	P.id = @policyId
			IF @result = 0
			BEGIN
				DECLARE @memberServers table(vsMemberServers xml);

				INSERT INTO @memberServers
				SELECT	CAST(IP.attrVal AS XML)
				FROM	App_VMAllocationPolicy P
						INNER JOIN App_VMDataCenterMap M
							ON P.vDataCenterId = M.vDataCenterId
						INNER JOIN APP_InstanceProp IP
							ON M.instanceId = IP.componentNameId
				WHERE	P.id = @policyId
					AND IP.attrName = 'Vs Member Servers'

				SELECT @result = MAX(dbo.IsClientVisible(@userId, ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0), 0, 0, 0, 0))
				FROM  @memberServers srvTab cross apply srvTab.vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
			END
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppCheckVMPolicySecurityPermissions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppCheckVMPolicySecurityPermissions' AND revision = '1.5.50.1')

  insert into GXDBVersions values(5, 'AppCheckVMPolicySecurityPermissions',  '1.5.50.1', 'AppCheckVMPolicySecurityPermissions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
