

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppCheckSecurityPermissions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppCheckSecurityPermissions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppCheckSecurityPermissions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppCheckSecurityPermissions]
  delete from GXDBVersions where name = 'AppCheckSecurityPermissions' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION AppCheckSecurityPermissions ( @userId integer, @securityInfo XML)
	RETURNS integer
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result integer
		SET @result = (SELECT 1 WHERE @userId IN (SELECT ref.value('@userId', 'integer')
					FROM  @securityInfo.nodes ('securityAssociations/users') R(ref)))
		IF (@result = 0 or @result IS NULL)
			IF ( (SELECT COUNT(UG.userId) from umusergroup AS UG where groupId in (SELECT ref.value('@userGroupId', 'integer')
			FROM  @securityInfo.nodes ('securityAssociations/userGroups') R(ref)) AND UG.userId=@userId) > 0)
				SET @result = 1
		IF (@result = 0 or @result IS NULL )
			IF ( (SELECT COUNT(EUG.userId) from umdsusergroup AS EUG where groupId in (SELECT ref.value('@groupId', 'integer')
			FROM  @securityInfo.nodes ('securityAssociations/externalUserGroups') R(ref)) AND EUG.userId=@userId) > 0)
				SET @result = 1
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppCheckSecurityPermissions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppCheckSecurityPermissions' AND revision = '1.4.208.1')

  insert into GXDBVersions values(5, 'AppCheckSecurityPermissions',  '1.4.208.1', 'AppCheckSecurityPermissions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
