

--  ------------  Generated from [../../../Source/CommServer/Db/Function/AlertDetectedTimeInUTC.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: AlertDetectedTimeInUTC'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AlertDetectedTimeInUTC]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AlertDetectedTimeInUTC]
  delete from GXDBVersions where name = 'AlertDetectedTimeInUTC' and type = 5
END
GO

				CREATE FUNCTION AlertDetectedTimeInUTC( @timeStr NVARCHAR(128))
				RETURNS DATETIME
				-- WITH ENCRYPTION
				BEGIN
				--@timeStr Format 'Tue Feb 11 21:46:48 2014'
				DECLARE strCur CURSOR FOR
				SELECT data FROM dbo.SplitString(@timeStr, ' ')   where data <> ' '
				DECLARE @i_level NVARCHAR(128)
				DECLARE @YEAR VARCHAR(32)
				DECLARE @MON VARCHAR(32)
				DECLARE @DAY VARCHAR(32)
				DECLARE @TIME VARCHAR(32)
				DECLARE @i INTEGER = 1
				OPEN strCur
				FETCH NEXT FROM strCur INTO @i_level
				WHILE @@FETCH_STATUS = 0
				BEGIN
						IF @i = 1
							goto Fetch_Next
						IF @i = 2
							SET @MON = (CASE @i_level WHEN 'Jan' THEN '01' WHEN 'Feb' THEN '02' WHEN 'Mar' THEN '03'
										WHEN 'Apr' THEN '04' WHEN 'May' THEN '05' WHEN 'Jun' THEN '06' WHEN 'Jul' THEN '07'
											WHEN 'Aug' THEN '08' WHEN 'Sep' THEN '09' WHEN 'Oct' THEN '10' WHEN 'Nov' THEN '11'
												WHEN 'Dec' THEN '12' END)
						IF @i =3
							SET @DAY =  @i_level

						IF @i = 4
							SET @TIME = @i_level
						IF @i = 5
							SET @YEAR =	@i_level

				Fetch_Next:
					SET @i = @i +1
					FETCH NEXT FROM strCur INTO @i_level
				END
				CLOSE strCur
				DEALLOCATE strCur
				DECLARE @FINAL VARCHAR(128) = @YEAR + '-' +@MON +'-'+ @DAY + ' ' + @TIME
				RETURN dbo.CellLocalToUTCTime(CONVERT(datetime,@FINAL),2)
				END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AlertDetectedTimeInUTC]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AlertDetectedTimeInUTC' AND revision = '')

  insert into GXDBVersions values(5, 'AlertDetectedTimeInUTC',  '', 'AlertDetectedTimeInUTC', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
