

--  ------------  Generated from [../../../Source/CommServer/Db/Function/APPIsClientSkewTimeUpdatable.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: APPIsClientSkewTimeUpdatable'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APPIsClientSkewTimeUpdatable]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[APPIsClientSkewTimeUpdatable]
  delete from GXDBVersions where name = 'APPIsClientSkewTimeUpdatable' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION APPIsClientSkewTimeUpdatable(@dbClientSkewTime INT, @newClientSkewTime INT)
	RETURNS INT
	BEGIN
		IF (@dbClientSkewTime = @newClientSkewTime)
		BEGIN
			-- Not updatable, same value so nothing to change
			RETURN 0
		END
		DECLARE @allowable INT = 10		-- seconds
		SELECT
			@allowable = gp.value
		FROM GXGlobalParam gp WITH(NOLOCK)
		WHERE
			gp.name  = N'AllowableClientSkewTimeBeforeUpdate'
			AND ISNUMERIC(gp.value) = 1
		-- valid range?
		IF (@allowable < 0 OR @allowable > 60)
		BEGIN
			SET @allowable = 10
		END
		-- compute interval between points
		DECLARE @interval INT = 0
		SELECT
			@interval = CASE
							WHEN @dbClientSkewTime >= 0 AND @newClientSkewTime >= 0 THEN ABS(@dbClientSkewTime - @newClientSkewTime)
							WHEN @dbClientSkewTime < 0 AND @newClientSkewTime < 0 THEN ABS(ABS(@dbClientSkewTime) - ABS(@newClientSkewTime))
							WHEN @dbClientSkewTime >= 0 AND @newClientSkewTime < 0 THEN ABS(@dbClientSkewTime - @newClientSkewTime)
							ELSE ABS(@newClientSkewTime - @dbClientSkewTime)
						END
		IF (@interval <= @allowable)
		BEGIN
			-- Not updatable yet, within variance range
			RETURN 0
		END
		RETURN 1
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [APPIsClientSkewTimeUpdatable]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'APPIsClientSkewTimeUpdatable' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'APPIsClientSkewTimeUpdatable',  '1.1.2.1', 'APPIsClientSkewTimeUpdatable', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
