

--  ------------  Generated from [../../../Source/CommServer/Db/Function/APPComputeGeoDistance.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: APPComputeGeoDistance'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APPComputeGeoDistance]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[APPComputeGeoDistance]
  delete from GXDBVersions where name = 'APPComputeGeoDistance' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	-- @distType 1: meters, 2: feet, 3: kilometers, 4: miles, Unknown value defaults 1
	CREATE FUNCTION APPComputeGeoDistance(@latitude1 FLOAT, @longitude1 FLOAT, @latitude2 FLOAT, @longitude2 FLOAT, @distType TINYINT = 1)
	RETURNS FLOAT
	AS
	BEGIN
		DECLARE @distance	FLOAT = 0
		DECLARE @srid		INT
		DECLARE @distDiv	FLOAT

		SELECT @srid = CASE @distType
							WHEN 1 THEN 4326	-- SRID Metre
							WHEN 2 THEN 4268	-- SRID US Feet
							WHEN 3 THEN 4326	-- SRID Metre
							WHEN 4 THEN 4268	-- SRID US Feet
							ELSE 4326	-- default
						END,
				@distDiv = CASE @distType
								WHEN 3 THEN 1000.0	-- meters per kilometer :-)
								WHEN 4 THEN 5280.0	-- feet per mile
								ELSE 1.0
							END

		DECLARE @pt1 GEOGRAPHY = GEOGRAPHY::Point(@latitude1, @longitude1, @srid)
		DECLARE @pt2 GEOGRAPHY = GEOGRAPHY::Point(@latitude2, @longitude2, @srid)

		SET @distance = @pt1.STDistance(@pt2) / @distDiv

		RETURN @distance
	END
	GO
	SET QUOTED_IDENTIFIER ON
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [APPComputeGeoDistance]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'APPComputeGeoDistance' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'APPComputeGeoDistance',  '1.1.2.2', 'APPComputeGeoDistance', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
