

--  ------------  Generated from [../../../Source/CommServer/Db/CCMTblScript/archGroupCopy.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @upgradeFromRelease INTEGER = 0

DECLARE @upgradeFromSPMajor INTEGER = 0

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF EXISTS (SELECT 1 FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1)

BEGIN

		SELECT @upgradeFromRelease = CAST(Status AS INTEGER)

		FROM   DBUpgradeSteps

		WHERE  Step = 'UpgradeFromRelease'

		SELECT @upgradeFromSPMajor = CAST(Status AS INTEGER)

		FROM   DBUpgradeSteps

		WHERE  Step = 'UpgradeFromSPMajor'

END

IF (@upgradeFromRelease = 14)

BEGIN

	UPDATE CCM_archGroupCopy SET flags = (flags|8388608) WHERE encType > 0 AND SIDBStoreId > 0

END

IF ((@upgradeFromRelease = 14) OR (@upgradeFromRelease = 15))

BEGIN

-- Set passThrough flag for the default option when upg from v9/v10 to v11

-- for non-dedup copies which have this option selected - copy encrypted data with existing cipher - the v11 upgrade equivalent is to switch to reencrypt option.

-- make sure no other enc flag is already set.

-- UPDATE CCM_archGroupCopy - to help search

UPDATE AGC

SET AGC.flags = (CASE WHEN ((AGC.encType = 0) AND (AGC.encKeyLen = 0)) THEN AGC.flags | 1048576 WHEN ((AGC.encType > 0) AND (AGC.encKeyLen > 0)) THEN AGC.flags | 8388608 END)

FROM CCM_archGroupCopy AGC

WHERE AGC.flags & 1048576 = 0

AND AGC.flags & 8388608 = 0

AND AGC.flags & 2097152 = 0

AND AGC.flags & 4194304 = 0

AND AGC.id NOT IN (SELECT defaultCopy FROM CCM_archGroup)

AND AGC.id NOT IN (SELECT defaultSnapCopy FROM CCM_archGroup)

END

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 3)

	)

        BEGIN

    -- execute below only if version we are running on is v11.

IF EXISTS (SELECT 1 FROM CCM_simAllGalaxyRel WHERE id = 16)

            BEGIN

                UPDATE CCM_archGroupCopy

SET extendedFlags = extendedFlags | 2048

                WHERE destMediaCopyId > 0

        END

END

IF ((@upgradeFromRelease = 14) OR (@upgradeFromRelease = 15) OR (@upgradeFromRelease = 16 AND @upgradeFromSPMajor <= 2))

BEGIN

	UPDATE CCM_archGroupCopy

SET extendedFlags = extendedFlags | 1024

	WHERE EXISTS (SELECT 1 FROM CCM_archFileCopy AFC WITH (READUNCOMMITTED) WHERE AFC.archCopyId = CCM_archGroupCopy.id AND AFC.encKeyType > 0)

	OR EXISTS (SELECT 1 FROM CCM_archFileSIDBKeys S WITH (READUNCOMMITTED) WHERE S.SIDBStoreId = CCM_archGroupCopy.SIDBStoreId)

END

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 9)

	)

        BEGIN

    -- we are executing below on v11 only so no additional version check is needed.

    UPDATE CCM_archGroupCopy

SET extendedFlags = extendedFlags | 65536

WHERE (((dedupeFlags & 134217728) > 0) OR ((extendedFlags & 2) > 0)

OR ((extendedFlags & 8192) > 0))

END

--Set dependent primary encryption flag on global policy if re-encrypt is set

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 12)

	)

BEGIN

    UPDATE 	CCM_archGroupCopy

SET 	extendedFlags = extendedFlags | 262144 /*CVA_ENCRYPT_ON_DEPENDENT_PRIMARY*/

    WHERE 	(

(dedupeFlags & 268435456) > 0  /*CVA_HOST_GLOBAL_DEDUP_STORE_FLAG*/

OR (extendedFlags & 1) > 0 /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/

OR (extendedFlags & 4096) > 0 /*CVA_GLOBAL_STORAGE_POLICY_FLAG*/

			)

AND (flags & 8388608) > 0 /*CVA_AUXCOPY_REENCRYPT_DATA_FLAG*/

END

