

--  ------------  Generated from [../../../Source/CommServer/Db/CCMTblScript/MMMountPath.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME CCM_MMMountPath

print '... inserting Table: CCM_MMMountPath'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME CCM_MMMountPath

-- set physical pruning enabled for all mount paths for a release to release upgrade only.

IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1)

BEGIN

IF EXISTS(SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' AND CAST(Status AS INTEGER) <= 15)

		BEGIN

			UPDATE CCM_MMMountPath

SET Attribute = Attribute | 8

			WHERE MountPathId > 0

		END

END

-- for hyperscale mount paths, set the reserve space to minimum between 40TB and 4% of total capacity.

IF EXISTS(SELECT 1 FROM CCM_MMMountPath WHERE Attribute & 64 = 64)

BEGIN

	DECLARE @40TB INT = 41943040 -- 40 TB is the max reserve space to set

	UPDATE MP

	SET MP.MagneticSpaceRsrvInMB =				(

													CEILING(

															( CASE WHEN MP.MagneticSpaceRsrvInMB < MS.TotalSpaceMB/25 THEN 

																(CASE WHEN MS.TotalSpaceMB/25 > @40TB THEN @40TB ELSE MS.TotalSpaceMB/25 END)

															  ELSE 

																(CASE WHEN MP.MagneticSpaceRsrvInMB > @40TB THEN @40TB ELSE MP.MagneticSpaceRsrvInMB END) 

															  END)

													/1024.0/1024.0) -- round to next TB

												)*1024*1024

	FROM  CCM_MMMountPath MP(NOLOCK), CCM_MMMediaSide MS(NOLOCK)

	WHERE MP.MediaSideId = MS.MediaSideId

AND   MP.Attribute & 64 = 64

END

