

--  ------------  Generated from [../../../Source/CommServer/Db/CCMTblScript/JMJobDataLink.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- CCM_JMJobDataLink.script

--

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 2011  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

OR

(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 10)

)

BEGIN

	/*

		If there is a storage policy change between Cycles then there could be a case where Full of the cycle is aged and Incremental is not aged because of invalid linking.

		And when below update query is execute, it might fail to find the Full/SynthFull for that Cycle causing the query to fail with NULL constraint error.

		Hence added the new Delete statement that would cleanup such entries from CCM_JMJobDataLink table.

	*/

	DELETE dataLink

	FROM CCM_JMBkpStats jmStats INNER JOIN CCM_JMJobDataLink dataLink

		ON dataLink.linkType = 6 AND jmStats.appType = 106 AND jmStats.jobId = dataLink.childJobId AND jmStats.commCellId = dataLink.commCellId

		WHERE NOT EXISTS (SELECT TOP 1 jobid FROM CCM_JMBkpStats bkpStats

							WHERE status IN (1,3,14) AND bkpLevel IN(1,64,128)

								AND bkpStats.appId = jmStats.appId AND bkpStats.fullCycleNum = jmStats.fullCycleNum

									ORDER BY servEndDate DESC )

	UPDATE dataLink

	SET parentJobId = (SELECT TOP 1 jobid FROM CCM_JMBkpStats bkpStats

							WHERE status IN (1,3,14) AND bkpLevel IN(1,64,128)

								AND bkpStats.appId = jmStats.appId AND bkpStats.fullCycleNum = jmStats.fullCycleNum

									ORDER BY servEndDate DESC )

	FROM CCM_JMBkpStats jmStats INNER JOIN CCM_JMJobDataLink dataLink

		ON dataLink.linkType = 6 AND jmStats.appType = 106 AND jmStats.jobId = dataLink.childJobId AND jmStats.commCellId = dataLink.commCellId

	DELETE CCM_JMJobDataStats

	FROM CCM_JMJobDataStats jds , CCM_archGroupCopy agc, CCM_APP_Application aa

                        WHERE archGrpCopyId = agc.id AND archGrpId <> archGroupId

                                    AND aa.id = jds.appId AND aa.appTypeId = 106

END

