

--  ------------  Generated from [../../../Source/CommServer/Db/CCMTblScript/ArchEncKeyProvider.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @now	INT = DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @UpgFromRel INT																								
  	DECLARE @UpgFromBuild INT																							
  	DECLARE @UpgFromSP INT																								
  																														
  	SELECT @UpgFromRel = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'					
  	SELECT @UpgFromBuild = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromBuild'				
  	SELECT @UpgFromSP = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor'

--Create default commvault provider

IF NOT EXISTS(SELECT 1 FROM CCM_ArchEncKeyProvider WHERE KeyProviderType = 1 /*CVA_ENC_KEY_PROVIDER_COMMVAULT*/)

BEGIN
	insert into CCM_ArchEncKeyProvider( KeyProviderId, KeyProviderName, KeyProviderType, EncType, EncKeyLength, Properties, Modified, Created, GUID )


values (1, 'Built-in', 1 /*CVA_ENC_KEY_PROVIDER_COMMVAULT*/, 3 /*Cvc::AES*/, 256, '', @now, @now, '29FCD63C-1065-4D90-83AE-16613B89FE04')

END

ELSE

BEGIN

	UPDATE 	CCM_ArchEncKeyProvider

	SET		EncKeyLength = 256

	WHERE	KeyProviderId = 1 AND EncKeyLength = 128

	UPDATE 	CCM_ArchEncKeyProvider

	SET		KeyProviderName = 'Built-in'

	WHERE	KeyProviderId = 1 AND KeyProviderName = 'COMMVAULT'

END

--if SafeNet is in use move SafeNet properties from CCM_GXGlobalParam table to this new table.

DECLARE @PropertiesFilePath nvarchar(max) = (SELECT value FROM CCM_GXGlobalParam WHERE name = 'SafeNetPropertiesFilePath')

IF ISNULL(@PropertiesFilePath, '') <> ''

AND NOT EXISTS(SELECT 1 FROM CCM_ArchEncKeyProvider WHERE KeyProviderType = 5 /*CVA_ENC_KEY_PROVIDER_SAFENET*/)

BEGIN

	DECLARE @EncType			INT = ISNULL((SELECT value FROM CCM_GXGlobalParam WHERE name = 'SafeNetEncryptionAlgorithm'), 3 /*I_KT_CryptographicAlgorithm_AES*/)

	DECLARE @EncKeyLength		INT = ISNULL((SELECT value FROM CCM_GXGlobalParam WHERE name = 'SafeNetEncryptionKeyLength'), 256)

	--From SP5a we are storing App::EncKeyProviderProperties xml string in properties column so convert existing value to xml

	SET @PropertiesFilePath = '<App_EncKeyProviderProperties configurationFilePath="' + @PropertiesFilePath + '" />'
	INSERT INTO CCM_ArchEncKeyProvider( KeyProviderName, KeyProviderType, EncType, EncKeyLength, Properties, Modified, Created, GUID )


VALUES ('SAFENET', 5 /*CVA_ENC_KEY_PROVIDER_SAFENET*/, @EncType, @EncKeyLength, @PropertiesFilePath, @now, @now, newid())

	DELETE CCM_GXGlobalParam

	WHERE	name in ('SafeNetPropertiesFilePath', 'SafeNetEncryptionAlgorithm', 'SafeNetEncryptionKeyLength')

END

--From SP5a we are storing App::EncKeyProviderProperties xml string in properties column so convert existing value to xml

--Upgrade from 11.0 SP5 or lower version

IF 	(

@UpgFromRel < 16 --11.0

		OR

		(

@UpgFromRel =  16  --11.0

			AND @UpgFromSP <  6

		)

	)

	AND EXISTS(SELECT 1 FROM CCM_ArchEncKeyProvider WHERE properties <> '' AND properties not like '%configurationFilePath%')

BEGIN

	UPDATE 	CCM_ArchEncKeyProvider

	SET		properties = '<App_EncKeyProviderProperties configurationFilePath="' + properties + '" />'

	WHERE	properties <> '' AND properties not like '%configurationFilePath%'

END

--

-- If CommServer specific passphrase is set before SP12 then move it to new PASSPHRASE provider

--

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 12)

	)

BEGIN

	DECLARE @l_properties xml = ISNULL(NULLIF((SELECT properties FROM CCM_ArchEncKeyProvider WHERE KeyProviderId = 1), ''), '<App_EncKeyProviderProperties/>')

	DECLARE @l_usePassphrase int

	DECLARE @l_passphraseFilePath varchar(2048)

	DECLARE @l_passphraseFileName varchar(256)

	SELECT	@l_usePassphrase = col.value('@usePassphrase', 'int'),

			@l_passphraseFilePath = col.value('@configurationFilePath', 'varchar(2048)')

	FROM 	@l_properties.nodes('App_EncKeyProviderProperties') as node(col)

	IF ISNULL(@l_usePassphrase, 0) = 1

	BEGIN

		--Separate file name from path

		DECLARE @l_pos int= CHARINDEX('\', REVERSE(@l_passphraseFilePath))

		SET @l_passphraseFileName =  RIGHT(@l_passphraseFilePath, @l_pos-1)

		SET @l_passphraseFilePath =  LEFT(@l_passphraseFilePath, LEN(@l_passphraseFilePath) - @l_pos)

		SET @l_properties =

		(

			SELECT 	@l_passphraseFileName AS '@passphraseFileName',

					id AS 'passphraseClient/client/@clientId',

					name AS 'passphraseClient/client/@clientName',

					@l_passphraseFilePath AS 'passphraseClient/filePath/@path'

			FROM	CCM_APP_Client

			WHERE 	id = 2

			FOR XML PATH('App_EncKeyProviderProperties')

		)

		--Add new passphrase provider

		DECLARE @l_keyProviderId int = 0
		INSERT INTO CCM_ArchEncKeyProvider( KeyProviderName, KeyProviderType, EncType, EncKeyLength, Properties, Modified, Created, GUID )


VALUES ('Passphrase', 6 /*CVA_ENC_KEY_PROVIDER_PHRASE*/, 3 /*Cvc::AES*/, 256,

				cast(@l_properties as nvarchar(max)), @now, @now, newid())

		SET @l_keyProviderId = SCOPE_IDENTITY()

		--Unset usePhrasephase for built-in provider

		UPDATE 	CCM_ArchEncKeyProvider

		SET 	Properties = '<App_EncKeyProviderProperties/>'

		WHERE	KeyProviderId = 1 /*Built-in provider*/

		--Associated all entities from built-in to new passphrase provider

		UPDATE	CCM_ArchCopyEncProperties

		SET		KeyProviderId = @l_keyProviderId

		WHERE	KeyProviderId = 1 /*built-in*/

		UPDATE 	CCM_GXGlobalParam

		SET		value = cast(@l_keyProviderId as nvarchar)

WHERE	name = 'CvPwdV5_KeyProviderId'

		--Set passphrase provider as default provider

IF EXISTS(SELECT 1 FROM CCM_GXGlobalParam WHERE name = 'DefaultKeyProviderForNewCopies')

		BEGIN

			UPDATE 	CCM_GXGlobalParam

			SET 	modified = @now

WHERE	name = 'DefaultKeyProviderForNewCopies'

					AND modified = 0

		END

	END

END

--Upgrade from 11.0 SP20 or lower version

IF 	(

@UpgFromRel < 16 --11.0

		OR

		(

@UpgFromRel =  16  --11.0

			AND @UpgFromSP <  21

		)

	)

BEGIN

	DECLARE @lt_KeyProviders TABLE (KeyProviderId INT, CredentialId INT, CredentialAssocId INT, ResourceName NVARCHAR(512), KMSProperties XML, CredInfo XML)
	INSERT INTO @lt_KeyProviders


	SELECT	K.KeyProviderId, CA.credentialId, CA.assocId, C.userName, K.Properties, C.credentialInfo

	FROM	CCM_ArchEncKeyProvider K, CCM_APP_CredentialAssoc CA, CCM_APP_Credentials C

WHERE	K.KeyProviderType = 4

			AND K.KeyProviderId = CA.entityId

AND CA.entityType = 178

			AND CA.credentialId = C.credentialId

	IF @@ROWCOUNT > 0

	BEGIN

		--

		-- We store key vault resource name in userName column of App_Credentials table so move it to credInfo xml 

		-- Set endpoints based on environment

		--

		UPDATE	K

		SET		CredInfo.modify

				(

					'insert 

						(

							attribute resourceName {sql:column("K.ResourceName")}, 

							<endpoints keyVaultEndpoint="{sql:column("T.vaultEndpoint")}" activeDirectoryEndpoint="{sql:column("T.authEndpoint")}" />

						) 

					into (/App_AdditionalCredInfo/azureCredInfo)[1]'

				)

		FROM	@lt_KeyProviders K,

				(

					SELECT	KP.KeyProviderId,

							(

								CASE CP.value('@environment', 'varchar(1024)')

								WHEN 'AzureUSGovernment'

								THEN 'vault.usgovcloudapi.net'

								WHEN 'AzureGermanCloud'

								THEN 'vault.microsoftazure.de'

								WHEN 'AzureChinaCloud'

								THEN 'vault.azure.cn'

								ELSE 'vault.azure.net'

								END

							)	vaultEndpoint,

							(

								CASE CP.value('@environment', 'varchar(1024)')

								WHEN 'AzureUSGovernment'

								THEN 'https://login.microsoftonline.us/'

								WHEN 'AzureGermanCloud'

								THEN 'https://login.microsoftonline.de/'

								WHEN 'AzureChinaCloud'

								THEN 'https://login.chinacloudapi.cn/'

								ELSE 'https://login.microsoftonline.com/'

								END

							)	authEndpoint

					FROM	@lt_KeyProviders KP

							CROSS APPLY KP.CredInfo.nodes('/App_AdditionalCredInfo/azureCredInfo')  C(CP)

				) AS T

		WHERE	K.KeyProviderId = T.KeyProviderId

		--

		-- Now merge the exising KMS properites and the azure credentail info from credential table. 

		--

		UPDATE	KP

		SET		Properties = T.Properties

		FROM	CCM_ArchEncKeyProvider KP,

				(

					SELECT	K.KeyProviderId, 

							(

								SELECT	KP.value('@sslPassPhrase', 'varchar(2048)') AS '@sslPassPhrase',

										CAST(REPLACE(CAST(CP.query('azureCredInfo') AS NVARCHAR(MAX)), 'azureCredInfo', 'keyVaultCredential') AS XML)

								FOR XML PATH('App_EncKeyProviderProperties')

							) Properties

					FROM	@lt_KeyProviders K

							CROSS APPLY K.KMSProperties.nodes('/App_EncKeyProviderProperties') P(KP)

							CROSS APPLY K.CredInfo.nodes('/App_AdditionalCredInfo')  C(CP)

				) AS T

		WHERE	KP.KeyProviderId = T.KeyProviderId

		DELETE	CA

		FROM	CCM_APP_CredentialAssoc CA, @lt_KeyProviders K

		WHERE	CA.assocId = K.CredentialAssocId

		DELETE	C

		FROM	CCM_APP_Credentials C, @lt_KeyProviders K

		WHERE	C.credentialId = K.CredentialId

				AND NOT EXISTS(SELECT 1 FROM CCM_APP_CredentialAssoc CA WHERE CA.credentialId = C.credentialId)

	END

	--

	-- Update App_Credentail if any other left

	--

	--

	UPDATE	K

	SET		credentialInfo.modify('insert <endpoints resourceManagerEndpoint="{sql:column("T.resourceManagerEndpoint")}" activeDirectoryEndpoint="{sql:column("T.authEndpoint")}" storageEndpoint="{sql:column("T.storageEndpoint")}" /> into (/App_AdditionalCredInfo/azureCredInfo)[1]')

	FROM	CCM_APP_Credentials K,

			(

				SELECT	KP.CredentialId,

						(

							CASE CP.value('@environment', 'varchar(1024)')

							WHEN 'AzureUSGovernment'

							THEN 'https://management.usgovcloudapi.net/'

							WHEN 'AzureGermanCloud'

							THEN 'https://management.microsoftazure.de/'

							WHEN 'AzureChinaCloud'

							THEN 'https://management.chinacloudapi.cn'

							ELSE 'https://management.azure.com/'

							END

						)	resourceManagerEndpoint,

						(

							CASE CP.value('@environment', 'varchar(1024)')

							WHEN 'AzureUSGovernment'

							THEN 'https://login.microsoftonline.us/'

							WHEN 'AzureGermanCloud'

							THEN 'https://login.microsoftonline.de/'

							WHEN 'AzureChinaCloud'

							THEN 'https://login.chinacloudapi.cn/'

							ELSE 'https://login.microsoftonline.com/'

							END

						)	authEndpoint,

						(

							CASE CP.value('@environment', 'varchar(1024)')

							WHEN 'AzureUSGovernment'

							THEN 'blob.core.usgovcloudapi.net'

							WHEN 'AzureGermanCloud'

							THEN 'blob.core.cloudapi.de'

							WHEN 'AzureChinaCloud'

							THEN 'blob.core.chinacloudapi.cn'

							ELSE 'blob.core.windows.net'

							END

						)	storageEndpoint

				FROM	CCM_APP_Credentials KP

						CROSS APPLY KP.credentialInfo.nodes('/App_AdditionalCredInfo/azureCredInfo')  C(CP)

			) AS T

	WHERE	K.CredentialId = T.CredentialId

			AND K.recordType = 4 /*App::CredentialType_AZUREACCOUNT*/

END

