

--  ------------  Generated from [../../../Source/CommServer/Db/CCMTblScript/App_SubClientProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

-- for release older than V11 SP19

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 19)

	)

BEGIN 

	-- Quota property rename.

	UPDATE CCM_App_SubClientProp SET attrName = N'Application Size' WHERE attrname = N'File System Quota Usage'

	-- Populate last backup job info

	IF OBJECT_ID('tempdb.dbo.#lastBackupInfoTmp') IS NOT NULL 

		DROP TABLE dbo.#lastBackupInfoTmp

	CREATE TABLE #lastBackupInfoTmp(subclientId INTEGER PRIMARY KEY, agentIdaId INT, jobId INT, commcellId INT, jobEndTime INT, lastBackupInfo XML);

	-- find all valid subclients 
	INSERT INTO #lastBackupInfoTmp(subclientId, agentIdaId)


	SELECT SC.id, IDA.id 

	FROM CCM_APP_Application AS SC WITH(NOLOCK)

	INNER JOIN CCM_APP_Client AS CL WITH(NOLOCK) ON 

                        SC.clientId = CL.id

                        AND (CL.status & 4) = 0                     -- deleted/agentless client

                        AND (SC.subclientStatus & 536) != 536           -- not an indexing subclient

                        AND (SC.subclientStatus & (16|32)) = 0          -- do not backup flags are no set

                        AND (SC.subclientStatus & 4) = 0            -- subclient is not deleted

                        AND CommServ.dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1   -- subclient is valid

                    INNER JOIN CCM_APP_BackupSetName AS BS WITH(NOLOCK) ON 

                        BS.id = SC.backupSet

                        AND BS.name <> N'defaultDummyBackupSet'

                    INNER JOIN CCM_APP_InstanceName AS INST WITH(NOLOCK) ON 

                        INST.id = SC.instance

                        AND INST.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')

                    INNER JOIN CCM_APP_IDAName AS IDA WITH(NOLOCK) ON 

                        IDA.clientId = SC.clientId

						AND IDA.appTypeId = SC.appTypeId

                    LEFT JOIN CCM_APP_SubClientProp p WITH(NOLOCK) ON 

                        p.componentNameId = SC.id

                        AND p.attrName IN (N'Index SubClient', N'DDB Backup')

                        AND p.modified = 0

                        AND p.attrVal = N'1'

                WHERE 

                    p.id IS NULL -- Not an index or DDB subclient

	-- Populate the jobIds

	UPDATE  L

	SET jobId = J.jobId,

		commcellId = J.commCellId,

		jobEndTime = J.servEndDate,

		lastBackupInfo = (

							SELECT	J.jobId AS '@jobID',

									J.commCellId AS '@commCellID',

									J.status AS '@status',

									J.failureReason AS '@failureReasonIds',

									J.failureReasonMsg AS '@failureReasonMessageEnglish',

									J.servEndDate AS 'endTime/@time'

							FOR XML PATH('lastBackupJobInfo'), TYPE

						 )

	FROM #lastBackupInfoTmp L 

	CROSS APPLY

	(

		SELECT TOP 1 jobId, commCellId, servEndDate, status, failureReason, CommServ.dbo.JMGetLocalizedMessageFunc(0, failureReason) AS failureReasonMsg

		FROM CCM_JMBkpStats AS BKP(NOLOCK) 

		WHERE BKP.appId = L.subclientId

		AND optype IN (4, 18, 59, 65, 30, 43) -- JMShouldUpdateLastBackupTime

		ORDER BY servEndDate DESC

	)J

	-- Save in subclient level
	INSERT INTO CCM_APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT subclientId, 'Last Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp

	WHERE jobId IS NOT NULL

	-- Remove all rows except 1 latest row per agent

	DELETE L1

	FROM #lastBackupInfoTmp L1

	CROSS APPLY

	(

		SELECT TOP 1 jobId, commcellId 

		FROM #lastBackupInfoTmp L2

		WHERE L2.agentIdaId = L1.agentIdaId

		ORDER BY L2.jobEndTime DESC

	)AL

	WHERE L1.jobId <> AL.jobId

	OR L1.jobId IS NULL

	-- Also save in agent level
	INSERT INTO CCM_APP_IDAProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT agentIdaId, 'Last Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp

	WHERE jobId IS NOT NULL

END

-- for release older than V11 SP21

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 21)

	)

BEGIN 

	-- Prune duplicate rows.

	DELETE SP

	FROM CCM_APP_SubClientProp SP

	INNER JOIN

	(

		SELECT ROW_NUMBER() OVER (PARTITION BY componentNameId ORDER BY id DESC) AS 'rowId', id

		FROM CCM_APP_SubClientProp

		WHERE attrName = 'Last Backup Job Info' AND modified = 0

	)T ON T.id = SP.id

	WHERE T.rowId > 1

	DELETE IP 

	FROM CCM_APP_IDAProp IP

	INNER JOIN

	(

		SELECT ROW_NUMBER() OVER (PARTITION BY componentNameId ORDER BY id DESC) AS 'rowId', id

		FROM CCM_APP_IDAProp

		WHERE attrName = 'Last Backup Job Info' AND modified = 0

	)T ON T.id = IP.id

	WHERE T.rowId > 1

END

SET  NOCOUNT OFF
