

--  ------------  Generated from [../../../Source/CommServer/Db/CCMTblScript/App_Client.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

-- for release older than V11 SP19

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

    OR 

    (

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 19)

    )

BEGIN

--1.	New scan feature should be enabled on subclients created post SP19-

--	As of now we don't want the feature to be enabled on existing subclients so we have decided to add a subclient property on all existing Isilon Network Share subclients(FS agents only) to indicating the feature is disabled.

--	You can use subclient property – 'NAS streaming snap scan enabled' and set it to 'false'

--	Newly created subclients will not have this subclient property so we will assume that the feature is enabled

--	There are different NAS vendors which support Network Share FS agents. As of now, it is not guaranteed to uniquely identify Isilon Network Share FS agents so you can add above subclient property on all Network Share agents with below exception

--	i.	If additional setting bEnableNasNetworkShareStreamingBackup is false or bEnableNasNetworkShareStreamingBackup is not available

--		Then set this property if a client property 'Client App Type' is set to 3(ClientAppType_ISILON) or client whose apptype is not determined

--	ii.	Without checking additional setting bEnableNasNetworkShareStreamingBackup set subclient property 'NAS streaming snap scan enabled' to false 

--		if a client property 'Client App Type' is set to 5(ClientAppType_NETAPP) or client whose apptype is not determined

--2.	Populated 'Client App Type' for all Network Share clients-

--	Currently, 'Client App Type' is set only for Nutanix Network Share clients. We want to populate this property on rest of the Network Share clients. This info will be helpful to display appropriate client info in GUI-

--	Set 'Client App Type' property if it is not already set using below steps only if client apptype is 3(Isilon) or 5(NetApp):

--	i.	Using client property 'NAS OS Type' determine the client application type with this mapping - https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/LibConfig/AppClientProp.cpp#10756

--	ii.	If above property is not present then use OSType filed from MMNDMPHostInfo table. Use above mapping.

--	iii.	If NDMP creds are not entered for the client then you will not find corresponding OSType. In this case, you can use 'SMControlHost' table and find engine type corresponding to the client. Use this engine ID to client app type mapping - https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/LibConfig/AppClientProp.cpp#9795

--	iv.	If none of the above successful then set the client type as 0.

IF OBJECT_ID('tempdb.dbo.#nasOSTypeToAppTypeMap') IS NOT NULL 

    DROP TABLE #nasOSTypeToAppTypeMap

    CREATE TABLE #nasOSTypeToAppTypeMap (osType NVARCHAR(8), appType INT)

	INSERT #nasOSTypeToAppTypeMap(osType, appType)

	VALUES

	(/*OS_TYPE_NUTANIX*/ N'34', /*ClientAppType_NUTANIX_AFS*/ 2),

	(/*OS_TYPE_ISILON*/ N'18', /*ClientAppType_ISILON*/ 3 ),

	(/*OS_TYPE_NETAPP*/ N'2', /*ClientAppType_NETAPP*/ 5 ),

	(/*OS_TYPE_DARTOS*/ N'1', /*ClientAppType_CELERRA_VNX*/ 6 ),

	(/*OS_TYPE_BLUEARC*/ N'9', /*ClientAppType_BLUEARC*/ 7 ),

	(/*OS_TYPE_UNITY*/ N'33', /*ClientAppType_UNITY*/ 8 ),

	(/*OS_TYPE_HUAWEI*/ N'32', /*ClientAppType_HUAWEI*/ 9 )

IF OBJECT_ID('tempdb.dbo.#vendorNameToAppTypeMap') IS NOT NULL 

    DROP TABLE #vendorNameToAppTypeMap

    CREATE TABLE #vendorNameToAppTypeMap (vendorName NVARCHAR(256), appType INT)

	INSERT #vendorNameToAppTypeMap(vendorName, appType)

	VALUES

	(/*SM_SNAPSHOT_ENGINE_NUTANIX_VENDORNAME*/ N'Nutanix', /*ClientAppType_NUTANIX_AFS*/ 2),

	(/*SM_SNAPSHOT_ENGINE_ISILON_VENDORNAME*/ N'Dell EMC Isilon', /*ClientAppType_ISILON*/ 3 ),

	(/*SM_SNAPSHOT_ENGINE_NETAPP_VENDORNAME*/ N'NetApp', /*ClientAppType_NETAPP*/ 5 ),

	(/*SM_SNAPSHOT_ENGINE_CELERRA_VENDORNAME*/ N'Dell EMC VNX / Celerra', /*ClientAppType_CELERRA_VNX*/ 6 ),

	(/*SM_SNAPSHOT_ENGINE_HNAS_VENDORNAME*/ N'Hitachi NAS', /*ClientAppType_BLUEARC*/ 7 ),

	(/*SM_SNAPSHOT_ENGINE_UNITY_VENDORNAME*/ N'Dell EMC Unity', /*ClientAppType_UNITY*/ 8 ),

	(/*SM_SNAPSHOT_ENGINE_HUAWEI_VENDORNAME*/ N'Huawei', /*ClientAppType_HUAWEI*/ 9 )

IF OBJECT_ID('tempdb.dbo.#networkShareClients') IS NOT NULL 

    DROP TABLE #networkShareClients

    CREATE TABLE #networkShareClients (clientId INT PRIMARY KEY,

										nasOSType INT DEFAULT 0,

										clientAppType INT DEFAULT 0)

	INSERT #networkShareClients(clientId)

	SELECT DISTINCT client.id

	FROM CCM_APP_Client client WITH(NOLOCK)

	LEFT JOIN CCM_APP_ClientProp prop WITH(NOLOCK) ON client.id = prop.componentnameid AND prop.attrName = N'Client App Type' AND prop.modified = 0

		WHERE prop.attrVal IS NULL 

		AND (client.status & 134217856) <> 0

		--0x8000080 = 134217856

		--CV_STATUS_NAS               0x0080 -- NAS CLIENTS

		--CV_STATUS_NON_NDMP          0x8000000 --Non NDMP

	UPDATE T

		SET T.nasOSType = CAST(attrVal AS INT)

	FROM #networkShareClients T

	INNER JOIN CCM_APP_ClientProp S WITH(NOLOCK) ON T.clientId = S.componentNameId

	WHERE S.attrName = N'NAS OS Type' AND S.modified = 0

	UPDATE T

		SET T.nasOSType = S.OSType

	FROM #networkShareClients T

	INNER JOIN CCM_MMNDMPHostInfo S WITH(NOLOCK) ON T.clientId = S.ClientId

	WHERE T.nasOSType = 0

	UPDATE T

		SET T.clientAppType = CAST(attrVal AS INT)

	FROM #networkShareClients T

	INNER JOIN CCM_App_ClientProp S WITH(NOLOCK) ON T.clientId = S.componentNameId

	WHERE S.attrName = N'Client App Type' AND S.modified = 0

	UPDATE T

		SET T.clientAppType = S.appType

	FROM #networkShareClients T

	INNER JOIN #nasOSTypeToAppTypeMap S ON S.osType = T.nasOSType

	WHERE T.clientAppType = 0

	UPDATE T

		SET T.clientAppType = S2.appType

	FROM #networkShareClients T

	INNER JOIN CCM_SMControlHost S1 WITH(NOLOCK) ON S1.ClientId = T.clientId

	INNER JOIN #vendorNameToAppTypeMap S2 ON S2.vendorName = S1.SnapVendorName

	WHERE T.clientAppType = 0

	--Set 'Client App Type' only if it is NetApp or Isilon.

	INSERT CCM_APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT clientId, N'Client App Type', 7, CAST(clientAppType AS NVARCHAR(16)), @nowTime, 0, 0 

	FROM #networkShareClients

	WHERE clientAppType = 3 /*ClientAppType_ISILON*/ 

	OR clientAppType = 5 /*ClientAppType_NETAPP*/

	DECLARE @bEnableNasNetworkShareStreamingBackup INT = 0

	--SET @bEnableNasNetworkShareStreamingBackup = ISNULL((SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK) WHERE keyName = 'bEnableNasNetworkShareStreamingBackup' AND CAST(value AS NVARCHAR(MAX)) = N'true' AND enabled = 1 AND relativePath = N'CommServDB.Console' AND entityId = 2 AND entityType = 3), 0)

	DECLARE @bEnableNetAppNetworkShareStreamingBackup INT = 0

	--SET @bEnableNetAppNetworkShareStreamingBackup = ISNULL((SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK) WHERE keyName = 'bEnableNetAppNetworkShareStreamingBackup' AND CAST(value AS NVARCHAR(MAX)) = N'true' AND enabled = 1 AND relativePath = N'CommServDB.Console' AND entityId = 2 AND entityType = 3), 0)

	--START: Subclients of NetAppClient

	--Without checking additional setting bEnableNasNetworkShareStreamingBackup, set subclient property 'NAS streaming snap scan enabled' 

	--on client having apptype 5(ClientAppType_NETAPP) or client whose apptype is not determined

	IF OBJECT_ID('tempdb.dbo.#networkShareNetAppClients') IS NOT NULL 

    	DROP TABLE #networkShareNetAppClients

	CREATE TABLE #networkShareNetAppClients (clientId INT PRIMARY KEY, clientAppType INT)

	INSERT #networkShareNetAppClients

	SELECT DISTINCT client.id, CAST(prop.attrVal AS INT)

	FROM CCM_APP_Client client WITH(NOLOCK)

	INNER JOIN CCM_APP_ClientProp prop WITH(NOLOCK) ON client.id = prop.componentnameid 

	WHERE prop.attrName = N'Client App Type' AND prop.attrVal = N'5' AND prop.modified = 0

		AND (client.status & 134217856) <> 0

		--0x8000080 = 134217856

		--CV_STATUS_NAS               0x0080 -- NAS CLIENTS

		--CV_STATUS_NON_NDMP          0x8000000 --Non NDMP

	UNION

	SELECT clientId, 0

	FROM #networkShareClients

	WHERE clientAppType = 0

	IF @bEnableNetAppNetworkShareStreamingBackup = 0

	BEGIN

		INSERT CCM_APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 FROM CCM_APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareNetAppClients nsClient ON nsClient.clientId = subclient.clientId

		WHERE subclient.appTypeId IN(33,29)/*33=WinFS, 29=LinuxFS*/

		AND NOT EXISTS(SELECT 1 FROM CCM_APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = subclient.id AND attrName = N'NAS streaming snap scan enabled' AND modified = 0)

	END

	ELSE

	BEGIN

		INSERT CCM_APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 FROM CCM_APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareNetAppClients nsClient ON nsClient.clientId = subclient.clientId

		WHERE subclient.appTypeId IN(33,29)/*33=WinFS, 29=LinuxFS*/	

		AND nsClient.clientAppType = 0

		AND NOT EXISTS(SELECT 1 FROM CCM_APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = subclient.id AND attrName = N'NAS streaming snap scan enabled' AND modified = 0)

	END

	--END: Subclients of NetAppClient

	IF OBJECT_ID('tempdb.dbo.#networkShareClientsWithoutNutanix') IS NOT NULL 

    DROP TABLE #networkShareClientsWithoutNutanix

    CREATE TABLE #networkShareClientsWithoutNutanix (clientId INT PRIMARY KEY, clientAppType INT)

	--If additional setting bEnableNasNetworkShareStreamingBackup is set to false or bEnableNasNetworkShareStreamingBackup is not available

	--Then set 'NAS streaming snap scan enabled' on client having apptype 3(ClientAppType_ISILON) or client whose apptype is not determined

	--Else set 'NAS streaming snap scan enabled' on client whose apptype is not determined

	INSERT #networkShareClientsWithoutNutanix

	SELECT DISTINCT client.id, CAST(prop.attrVal AS INT)

	FROM CCM_APP_Client client WITH(NOLOCK)

	INNER JOIN CCM_APP_ClientProp prop ON client.id = prop.componentnameid 

	WHERE prop.attrName = N'Client App Type' AND prop.attrVal = N'3' AND prop.modified = 0

		AND (client.status & 134217856) <> 0

		--0x8000080 = 134217856

		--CV_STATUS_NAS               0x0080 -- NAS CLIENTS

		--CV_STATUS_NON_NDMP          0x8000000 --Non NDMP

	UNION

	SELECT clientId, 0

	FROM #networkShareClients

	WHERE clientAppType = 0

	IF @bEnableNasNetworkShareStreamingBackup = 0

	BEGIN		

		UPDATE T 

			SET modified = @nowTime

		FROM CCM_APP_SubClientProp T

		INNER JOIN CCM_APP_Application subclient WITH(NOLOCK) ON T.componentNameId = subclient.id

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

		WHERE T.attrName = N'NAS streaming snap scan enabled'

		AND T.modified = 0

		INSERT CCM_APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 FROM CCM_APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

	END

	ELSE

	BEGIN

		UPDATE T 

			SET modified = @nowTime

		FROM CCM_APP_SubClientProp T

		INNER JOIN CCM_APP_Application subclient WITH(NOLOCK) ON T.componentNameId = subclient.id

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

		WHERE 

			nsClient.clientAppType = 0

		AND T.attrName = N'NAS streaming snap scan enabled'

		AND T.modified = 0

		INSERT CCM_APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		SELECT subclient.id, N'NAS streaming snap scan enabled', 2, N'0', @nowTime, 0, 0 

		FROM CCM_APP_Application subclient WITH(NOLOCK)

		INNER JOIN #networkShareClientsWithoutNutanix nsClient ON nsClient.clientId = subclient.clientId

		WHERE nsClient.clientAppType = 0

	END

	-- for release older than V11 SP20

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

		OR 

		(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 20)

		)

	BEGIN 
		INSERT INTO CCM_APP_ClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)


		SELECT distinct clientid,'Client App Type',7,'11',@nowTime,0,0 ---enum ClientAppType Epic

		FROM CCM_App_client c

		JOIN CCM_App_application a ON a.clientId=C.id

		INNER JOIN CCM_APP_ScFilterFile f ON f.componentNameId=a.id AND (f.fileName LIKE '/Epic%' OR f.filename LIKE '%CACHEDB%') AND f.modified=0

		LEFT JOIN CCM_APP_ClientProp cp ON cp.componentNameId=A.clientId AND attrName = 'client App type' AND cp.modified=0

		WHERE CP.attrVal<>'11' OR CP.attrVal IS NULL

	END

END	

SET  NOCOUNT OFF

