

--  ------------  Generated from [../../../Source/CommServer/Db/CCMTblScript/APP_ClientProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ----------------------------------------------------------------------

-- Copyright (c) 2020 Commvault Systems, Inc.

-- All rights reserved.

-- 

-- This is unpublished proprietary source code of CommVault

-- Systems, Inc. The copyright notice above does not evidence

-- any actual or intended publication of such source code.

-- ----------------------------------------------------------------------

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/CCMTblScript/APP_ClientProp.script,v $ $Id: APP_ClientProp.script,v 1.1.2.2.8.1 2021/04/21 18:13:03 snair Exp $";

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

-- for release older than V11 SP20

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 21)

	)

BEGIN 

	DECLARE @curtime INT = DATEDIFF(SECOND, '01/01/1970', GETUTCDATE())

	DECLARE @indexingV2EnabledMaskAttrName nvarchar(22) = 'IndexingV2_EnabledMask'

	-- Insert temporary bitmask values for each app type

	IF OBJECT_ID('tempdb.dbo.#tempIdxV2AppTypes') IS NOT NULL 

		DROP TABLE #tempIdxV2AppTypes

	CREATE TABLE #tempIdxV2AppTypes (name NVARCHAR(128), idxPos BIGINT)
	INSERT INTO #tempIdxV2AppTypes (name, idxPos) VALUES


		('IndexingV2',                      POWER(2.0, 0)),

		('IndexingV2_Oracle',               POWER(2.0, 8)),

		('IndexingV2_NAS',                  POWER(2.0, 2)),

		('IndexingV2_VSA',                  POWER(2.0, 1)),

		('IndexingV2_SF',                   POWER(2.0, 35)),

		('IndexingV2_ExchangeMailbox',      POWER(2.0, 5)),

		('IndexingV2_MSSqlServer',          POWER(2.0, 6)),

		('IndexingV2_Azure',                POWER(2.0, 3)),

		('IndexingV2_S3',                   POWER(2.0, 33)),

		('IndexingV2_SAPHANA',              POWER(2.0, 9)),

		('IndexingV2_Postgress',            POWER(2.0, 32)),

		('IndexingV2_ExchangeDB',           POWER(2.0, 17)),

		('IndexingV2_postponed',            POWER(2.0, 37)),

		('IndexingV2_OneDrive',             POWER(2.0, 7)),

		('IndexingV2_SharePoint',           POWER(2.0, 10)),

		('IndexingV2_MSDynamics365',        POWER(2.0, 11)),

		('IndexingV2_MSTeams',              POWER(2.0, 12)),

		('IndexingV2_CloudPaaS',            POWER(2.0, 13)),

		('IndexingV2_AzureDataLake',        POWER(2.0, 14)),

		('IndexingV2_AzureDevOps',          POWER(2.0, 15)),

		('IndexingV2_AzureTableStorage',    POWER(2.0, 16)),

		('IndexingV2_OracleStorageService', POWER(2.0, 18)),

		('IndexingV2_AlibabaOSS',           POWER(2.0, 19)),

		('IndexingV2_CosmosDBSQL',          POWER(2.0, 20)),

		('IndexingV2_DB2',                  POWER(2.0, 21)),

		('IndexingV2_DB2_DPF',              POWER(2.0, 22)),

		('IndexingV2_Documentum',           POWER(2.0, 23)),

		('IndexingV2_Dynamic365',           POWER(2.0, 24)),

		('IndexingV2_DynamoDB',             POWER(2.0, 25)),

		('IndexingV2_GitHub',               POWER(2.0, 26)),

		('IndexingV2_GoogleCloud',          POWER(2.0, 27)),

		('IndexingV2_IBMCOS',               POWER(2.0, 28)),

		('IndexingV2_Informix',             POWER(2.0, 29)),

		('IndexingV2_MySQL',                POWER(2.0, 30)),

		('IndexingV2_OpenStack',            POWER(2.0, 31)),

		('IndexingV2_SAP_FOR_ORACLE',       POWER(2.0, 34)),

		('IndexingV2_Sybase',               POWER(2.0, 36)),

		('IndexingV2_AzureAD',              POWER(2.0, 4))

	--Based on the existing IndexingV2_* attributes in CCM_APP_ClientProp, crete the IndexingV2_EnabledMask attr
	INSERT INTO CCM_APP_ClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)


	SELECT componentNameId, @indexingV2EnabledMaskAttrName, 2, SUM(ISNULL(i.idxPos, 0)), @curtime, 0, 0

	FROM CCM_APP_ClientProp CP WITH(NOLOCK)

		LEFT OUTER JOIN #tempIdxV2AppTypes i WITH(NOLOCK) ON

			i.name = CP.attrName

	WHERE 

		CP.attrName LIKE 'IndexingV2%' 

		AND CP.attrName <> 'IndexingV2_EnabledMask' -- To avoid warn: "Null value is eliminated by an aggregate or other SET operation."

		AND CP.attrVal = '1'

		AND CP.modified = 0

	GROUP BY componentNameId

END

-- for release older than V11 SP23

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) < 16)

	OR 

	(

EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' and CAST(Status AS INTEGER) = 16)

AND EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor' and CAST(Status AS INTEGER) < 23)

	)

BEGIN

	-- delete property 'Cloud Mode Enabled' since it is not needed

delete from CCM_APP_ClientProp where attrName = 'Cloud Mode Enabled'

END

SET  NOCOUNT OFF

