

--  ------------  Generated from [../../../Source/CommServer/CacheDB/Sp/QS_GetQscriptExec.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CacheDB/Sp/QS_GetQscriptExec.sp,v $ $Id: QS_GetQscriptExec.sp,v 1.1.2.1 2018/12/01 22:21:32 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetQscriptExec')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetQscriptExec <<<'
	drop procedure QS_GetQscriptExec
END
IF EXISTS (select * from GxQscripts where name='QS_GetQscriptExec')
	delete from GxQscripts where name = 'QS_GetQscriptExec'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptExec')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptExec'
GO
print '... Creating Procedure: QS_GetQscriptExec'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetQscriptExec
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_name varchar(1024)='',
  @i_from varchar(1024)='',
  @i_to varchar(1024)='',
  @i_status int = 0
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	IF @i_status not in (0, 1, 2)
	BEGIN
		SET @localErrorMsg = 'Error: Invalid status!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	DECLARE @tblQscriptList TABLE
	(
		QscriptName varchar(64),
		TimeStart	datetime,
		TimeEnd		datetime,
		Status		int,
		InputParams	varchar(max)
	)
	INSERT INTO @tblQscriptList
	SELECT 	name, timeStart, timeEnd, status, inputParams
	FROM GxQscriptExec
	WHERE (name = @i_name OR name = 'QS_' + @i_name)
	AND (@i_status = 0 OR status = @i_status)
	AND (@i_from = '' OR timeStart > @i_from) AND (@i_to = '' OR timeEnd < @i_to)
	IF @@ROWCOUNT = 0
	BEGIN
		SET @localErrorMsg = 'Error: No execution record found!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	SELECT * FROM @tblQscriptList
	ORDER BY QscriptName, TimeStart desc
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetQscriptExec')
	delete from GxQscripts where name = 'QS_GetQscriptExec'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptExec')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptExec'
GO

insert into GXDBVersions values(2, 'QS_GetQscriptExec',  '00010001000200010000', 'QS_GetQscriptExec', '00010001000200010000')
GO

insert into GxQscripts values(2,'QS_GetQscriptExec',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn getQscriptExec -si @i_name=''script_name'' -si @i_from=''from_time'' -si @i_to=''to_time'' -si @i_status=''exec_status''
'
 + CHAR(10) + '	qoperation execscript -sn getQscriptExec -si ''script_name'' -si ''from_time'' -si ''to_time'' -si ''exec_status''
'
 + CHAR(10) + '-- 	script_name: full script name.'
 + CHAR(10) + '-- 	from_time: SQL datetime. For example ''01/01/2010''. Ignored if not given.'
 + CHAR(10) + '-- 	to_time: SQL datetime. For example ''06/01/2010''. Ignored if not given.'
 + CHAR(10) + '-- 	exec_status: 1 for successful execution, 2 for failed execution. 0 for all status.'
)
GO

