-- This script checks whether DB is on 10.0 release
-- This script checks whether Service pack level on 10.0 is SP9 and higher
-- This script checks whether Service pack level on 11.0 is SP0 and higher

DECLARE @DBVersionId INTEGER
SET 	@DBVersionId = 0

DECLARE @DBVersion VARCHAR(128)
SET 	@DBVersion = 0

DECLARE @CurrentSPLevel INTEGER
SET 	@CurrentSPLevel = 0

DECLARE @CurRelDBVersionId INTEGER					--11.0
SET 	@CurRelDBVersionId = 16

DECLARE @LastRelDBVersionId INTEGER					--10.0
SET 	@LastRelDBVersionId = 15

DECLARE @SupportedSPLevelForLastRel INTEGER			--10.0
SET 	@SupportedSPLevelForLastRel = 9

DECLARE @errorCode INTEGER 
SET			@errorCode = 0

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

PRINT @DescTag + ' Check for supported release and minimum Service Pack Level on CVCloud'

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE id = OBJECT_ID(N'[dbo].[SimAllGalaxyRel]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	SELECT TOP 1 @DBVersionId = id, @DBVersion = release FROM SimAllGalaxyRel ORDER BY id DESC
END
ELSE
BEGIN
	SET @errorCode = -1
	GOTO CX_EXIT
END

SET	@errorCode	=	@@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

IF @DBVersionId NOT IN (@LastRelDBVersionId, @CurRelDBVersionId)
BEGIN
	SET @errorCode = -2
	GOTO CX_EXIT
END

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE id = OBJECT_ID(N'[dbo].[PatchDBSPInfo]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	SELECT @CurrentSPLevel = MAX(SPNumber) FROM PatchDBSPInfo
END	
ELSE
BEGIN
	SET @errorCode = -3
	GOTO CX_EXIT
END

SET	@errorCode	=	@@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

IF (@DBVersionId = @LastRelDBVersionId AND @CurrentSPLevel < @SupportedSPLevelForLastRel)
BEGIN
	SET @errorCode = -4
	GOTO CX_EXIT
END

CX_EXIT: 
	IF @errorCode != 0 
	BEGIN

		IF @errorCode = -1
		BEGIN
			PRINT @ErrorTag + ' Failed to check the software release. SimAllGalaxyRel table missing.'
		END
		ELSE IF @errorCode = -2
		BEGIN
			PRINT  @ErrorTag + ' Current Release ' + @DBVersion + ' is not supported for upgrade to version 11.'
		END
		ELSE IF @errorCode = -3
		BEGIN
			PRINT  @ErrorTag + ' Failed to check current service pack information. PatchInfo table missing.'
		END
		ELSE IF @errorCode = -4
		BEGIN
			PRINT  @ErrorTag + ' Current Service Pack Level [SP' + CAST(@CurrentSPLevel AS VARCHAR(10)) + '] is not supported for upgrade to version 11.'
			PRINT  @AdviceTag + ' Please install Service Pack [SP' + CAST(@SupportedSPLevelForLastRel AS VARCHAR(10)) + '] before upgrading to version 11.'
		END
		ELSE
		BEGIN	
			PRINT  @ErrorTag + ' Failed to check the software release/service pack information.'
		END
			
		SELECT 2

	END
	ELSE
		SELECT 0
			
	RETURN
